/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IteratorImpl
implements HibernateIterator {
    private static final Logger log = LoggerFactory.getLogger((Class)IteratorImpl.class);
    private ResultSet rs;
    private final EventSource session;
    private boolean readOnly;
    private final Type[] types;
    private final boolean single;
    private Object currentResult;
    private boolean hasNext;
    private final String[][] names;
    private PreparedStatement ps;
    private HolderInstantiator holderInstantiator;

    public IteratorImpl(ResultSet rs, PreparedStatement ps, EventSource sess, boolean readOnly, Type[] types, String[][] columnNames, HolderInstantiator holderInstantiator) throws HibernateException, SQLException {
        this.rs = rs;
        this.ps = ps;
        this.session = sess;
        this.readOnly = readOnly;
        this.types = types;
        this.names = columnNames;
        this.holderInstantiator = holderInstantiator;
        this.single = types.length == 1;
        this.postNext();
    }

    /*
     * Loose catch block
     */
    public void close() throws JDBCException {
        block8: {
            if (this.ps != null) {
                log.debug("closing iterator");
                this.session.getBatcher().closeQueryStatement(this.ps, this.rs);
                this.ps = null;
                this.rs = null;
                this.hasNext = false;
                Object var3_1 = null;
                try {
                    this.session.getPersistenceContext().getLoadContexts().cleanup(this.rs);
                }
                catch (Throwable ignore) {
                    log.trace("exception trying to cleanup load context : " + ignore.getMessage());
                }
                break block8;
                {
                    catch (SQLException e) {
                        log.info("Unable to close iterator", (Throwable)e);
                        throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), e, "Unable to close iterator");
                    }
                }
                catch (Throwable throwable) {
                    Object var3_2 = null;
                    try {
                        this.session.getPersistenceContext().getLoadContexts().cleanup(this.rs);
                    }
                    catch (Throwable ignore) {
                        log.trace("exception trying to cleanup load context : " + ignore.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    private void postNext() throws SQLException {
        log.debug("attempting to retrieve next results");
        this.hasNext = this.rs.next();
        if (!this.hasNext) {
            log.debug("exhausted results");
            this.close();
        } else {
            log.debug("retrieved next results");
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() throws HibernateException {
        Object object;
        if (!this.hasNext) {
            throw new NoSuchElementException("No more results");
        }
        boolean sessionDefaultReadOnlyOrig = this.session.isDefaultReadOnly();
        this.session.setDefaultReadOnly(this.readOnly);
        try {
            boolean isHolder = this.holderInstantiator.isRequired();
            log.debug("assembling results");
            if (this.single && !isHolder) {
                this.currentResult = this.types[0].nullSafeGet(this.rs, this.names[0], (SessionImplementor)this.session, null);
            } else {
                Object[] currentResults = new Object[this.types.length];
                for (int i = 0; i < this.types.length; ++i) {
                    currentResults[i] = this.types[i].nullSafeGet(this.rs, this.names[i], (SessionImplementor)this.session, null);
                }
                this.currentResult = isHolder ? this.holderInstantiator.instantiate(currentResults) : currentResults;
            }
            this.postNext();
            log.debug("returning current results");
            object = this.currentResult;
            Object var6_6 = null;
        }
        catch (SQLException sqle) {
            try {
                throw JDBCExceptionHelper.convert(this.session.getFactory().getSQLExceptionConverter(), sqle, "could not get next iterator result");
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.session.setDefaultReadOnly(sessionDefaultReadOnlyOrig);
                throw throwable;
            }
        }
        this.session.setDefaultReadOnly(sessionDefaultReadOnlyOrig);
        return object;
    }

    public void remove() {
        if (!this.single) {
            throw new UnsupportedOperationException("Not a single column hibernate query result set");
        }
        if (this.currentResult == null) {
            throw new IllegalStateException("Called Iterator.remove() before next()");
        }
        if (!(this.types[0] instanceof EntityType)) {
            throw new UnsupportedOperationException("Not an entity");
        }
        this.session.delete(((EntityType)this.types[0]).getAssociatedEntityName(), this.currentResult, false, null);
    }
}

