package org.gcube.dbinterface.h2.query.update;

import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.queries.update.Update;
import org.gcube.common.dbinterface.tables.Table;



public class UpdateImpl extends Update{

	String query="UPDATE <%TABLE%> SET <%OPERATOR%> <%FROMTABLE%> <%WHERE%>";

	@SuppressWarnings("rawtypes")
	@Override
	public String getUpdateQuery() {
		String operator="";
		if (this.getOperators()!=null && this.getOperators().length>0){
			StringBuilder attrBuilder= new StringBuilder();
			for (OperatorCondition ops: this.getOperators()){
				attrBuilder.append(ops.getCondition());
				attrBuilder.append(" ,");
			}
			operator=  attrBuilder.substring(0, attrBuilder.length()-2);
		}
		
		String fromTable="";
		if (this.getFromTable()!=null && this.getFromTable().length>0){
			StringBuilder fromtableBuilder= new StringBuilder(" FROM ");
			for (Table table: this.getFromTable()){
				fromtableBuilder.append(table.getTable());
				fromtableBuilder.append(" ,");
			}
			fromTable=  fromtableBuilder.substring(0, fromtableBuilder.length()-2);
		}
		
		String filter=this.getFilter()!=null?" WHERE "+this.getFilter().getCondition():"";
				
		return  query.replace("<%TABLE%>", this.getTable().getTableName()).replace("<%OPERATOR%>",operator).replace("<%WHERE%>", filter).replace("<%FROMTABLE%>", fromTable);

	}
	
	
	
}
