package org.gcube.dbinterface.h2.query;

import java.util.List;

import org.gcube.common.dbinterface.ForeignKey;

public class ForeignKeyImpl extends ForeignKey {

	private final String query="FOREIGN KEY (<%INTERNALCOLUMNNS%>) REFERENCES <%TABLE%> (<%EXTERNALCOLUMNS%>)"; 
		
		
	@Override
	public String getDefinition() {
		return query.replace("<%INTERNALCOLUMNNS%>", asStringList(getAttributes()))
				.replace("<%TABLE%>", getExternalTable())
				.replace("<%EXTERNALCOLUMNS%>", asStringList(getExternalAttributes()));
	}

	private String asStringList(List<String> objects){
		StringBuffer toReturn = new StringBuffer();
		for (String item: objects)
			toReturn.append(item+",");
		return toReturn.substring(0, toReturn.length()-1);
		
	}

	
}
