/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.gxrest.request.GXHTTP;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXWebTargetAdapterRequest
implements GXHTTP {
    private final WebTarget adaptee;
    private static final Logger logger = LoggerFactory.getLogger(GXWebTargetAdapterRequest.class);
    private Entity<?> entity;

    public static GXWebTargetAdapterRequest newRequest(String address) {
        return new GXWebTargetAdapterRequest(address);
    }

    public GXWebTargetAdapterRequest(String address) {
        Client client = ClientBuilder.newClient();
        this.adaptee = client.target(address);
        this.property("gcube-token", SecurityTokenProvider.instance.get());
    }

    public GXWebTargetAdapterRequest setSecurityToken(String token) {
        this.property("gcube-token", token);
        return this;
    }

    public GXWebTargetAdapterRequest property(String name, String value) {
        this.adaptee.property(name, (Object)value);
        return this;
    }

    public void register(Object component) {
        this.adaptee.register(component);
    }

    public GXWebTargetAdapterRequest path(String path) throws UnsupportedEncodingException {
        this.adaptee.path(path);
        return this;
    }

    public GXWebTargetAdapterRequest queryParams(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            for (String key : parameters.keySet()) {
                this.adaptee.queryParam(URLEncoder.encode(key, "UTF-8"), new Object[]{URLEncoder.encode(parameters.get(key), "UTF-8")});
            }
        }
        return this;
    }

    public GXWebTargetAdapterRequest withEntity(Entity<?> entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public GXInboundResponse put() throws Exception {
        Response response = this.adaptee.request().put(this.entity);
        return new GXInboundResponse(response);
    }

    @Override
    public GXInboundResponse delete() throws Exception {
        Response response = this.adaptee.request().delete();
        return new GXInboundResponse(response);
    }

    @Override
    public GXInboundResponse post() throws Exception {
        Response response = (Response)this.adaptee.request().post(this.entity, Response.class);
        return new GXInboundResponse(response);
    }

    @Override
    public GXInboundResponse head() throws Exception {
        Response response = this.adaptee.request().head();
        return new GXInboundResponse(response);
    }

    @Override
    public GXInboundResponse get() throws Exception {
        Response response = (Response)this.adaptee.request().get(Response.class);
        return new GXInboundResponse(response);
    }
}

