/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.gxhttp.reference.GXHTTP;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXWebTargetAdapterRequest
implements GXHTTP<Entity<?>, GXInboundResponse> {
    private WebTarget adaptee;
    private static final Logger logger = LoggerFactory.getLogger(GXWebTargetAdapterRequest.class);
    private MediaType[] mediaType;
    MultivaluedMap<String, Object> headers = new MultivaluedHashMap();
    private boolean extCall = false;

    public static GXWebTargetAdapterRequest newRequest(String address) {
        return new GXWebTargetAdapterRequest(address, false);
    }

    public static GXWebTargetAdapterRequest newHTTPSRequest(String address) {
        return new GXWebTargetAdapterRequest(address, true);
    }

    private GXWebTargetAdapterRequest(String address, boolean withHTTPS) {
        Client client = ClientBuilder.newClient();
        if (withHTTPS) {
            try {
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }
                }};
                sc.init(null, certs, new SecureRandom());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                client = ClientBuilder.newBuilder().sslContext(sc).hostnameVerifier(allHostsValid).build();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                client = ClientBuilder.newClient();
            }
        }
        this.adaptee = client.target(address);
        this.headers.add((Object)"gcube-token", (Object)SecurityTokenProvider.instance.get());
        this.headers.add((Object)"User-Agent", (Object)this.getClass().getSimpleName());
    }

    public void setSecurityToken(String token) {
        if (this.extCall) {
            throw new UnsupportedOperationException("Cannot set the security token on an external call");
        }
        this.headers.add((Object)"gcube-token", (Object)token);
    }

    public GXWebTargetAdapterRequest from(String agent) {
        this.headers.add((Object)"User-Agent", (Object)this.getClass().getSimpleName());
        return this;
    }

    public GXWebTargetAdapterRequest configProperty(String name, String value) {
        this.adaptee = (WebTarget)this.adaptee.property(name, (Object)value);
        return this;
    }

    public GXWebTargetAdapterRequest register(Object component) {
        this.adaptee = (WebTarget)this.adaptee.register(component);
        return this;
    }

    public GXWebTargetAdapterRequest register(Class<?> component) {
        this.adaptee = (WebTarget)this.adaptee.register(component);
        return this;
    }

    public GXWebTargetAdapterRequest path(String path) throws UnsupportedEncodingException {
        this.adaptee = this.adaptee.path(path);
        return this;
    }

    public GXWebTargetAdapterRequest queryParams(Map<String, Object[]> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            for (Map.Entry<String, Object[]> parameter : parameters.entrySet()) {
                this.adaptee = this.adaptee.queryParam(URLEncoder.encode(parameter.getKey(), "UTF-8"), parameter.getValue());
            }
        }
        return this;
    }

    public GXWebTargetAdapterRequest setAcceptedResponseType(MediaType ... acceptedResponseTypes) {
        this.mediaType = acceptedResponseTypes;
        return this;
    }

    public GXInboundResponse delete() throws Exception {
        logger.trace("Sending a DELETE request...");
        Response response = this.buildRequest().delete();
        return this.buildGXResponse(response);
    }

    public GXInboundResponse head() throws Exception {
        logger.trace("Sending a HEAD request...");
        Response response = this.buildRequest().head();
        return this.buildGXResponse(response);
    }

    public GXInboundResponse get() throws Exception {
        logger.trace("Sending a GET request...");
        Response response = (Response)this.buildRequest().get(Response.class);
        return this.buildGXResponse(response);
    }

    private Invocation.Builder buildRequest() {
        Invocation.Builder builder = this.adaptee.request();
        builder.headers(this.headers);
        return builder;
    }

    public GXWebTargetAdapterRequest header(String name, Object value) {
        this.headers.add((Object)name, value);
        return this;
    }

    public GXInboundResponse put(Entity<?> body) throws Exception {
        logger.trace("Sending a PUT request...");
        if (Objects.nonNull(body)) {
            return this.buildGXResponse(this.buildRequest().put(body));
        }
        throw new IllegalArgumentException("Invalid body for the PUT request");
    }

    public GXInboundResponse put() throws Exception {
        logger.trace("Sending a PUT request with no body...");
        return this.buildGXResponse(this.buildRequest().put(null));
    }

    public GXInboundResponse post(Entity<?> body) throws Exception {
        Objects.requireNonNull(body, "Cannot send a POST request with a null body.");
        logger.trace("Sending a POST request...");
        Response response = (Response)this.buildRequest().post(body, Response.class);
        return this.buildGXResponse(response);
    }

    public GXInboundResponse post() throws Exception {
        logger.trace("Sending a POST request with no body...");
        Response response = (Response)this.buildRequest().post(null, Response.class);
        return this.buildGXResponse(response);
    }

    private GXInboundResponse buildGXResponse(Response source) {
        return Objects.isNull(this.mediaType) ? new GXInboundResponse(source) : new GXInboundResponse(source, this.mediaType);
    }

    public GXInboundResponse trace() throws Exception {
        logger.trace("Sending a TRACE request with no body...");
        Response response = (Response)this.buildRequest().trace(Response.class);
        return this.buildGXResponse(response);
    }

    public GXInboundResponse patch() throws Exception {
        throw new UnsupportedOperationException("WebTarget does not support PATCH");
    }

    public GXInboundResponse options() throws Exception {
        logger.trace("Sending an OPTIONS request with no body...");
        Response response = (Response)this.buildRequest().options(Response.class);
        return this.buildGXResponse(response);
    }

    public GXInboundResponse connect() throws Exception {
        throw new UnsupportedOperationException("WebTarget does not support CONNECT");
    }

    public void isExternalCall(boolean ext) {
        this.extCall = ext;
    }
}

