package org.gcube.common.geoserverinterface.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.HttpResourceControl;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.common.geoserverinterface.json.JSONArray;
import org.gcube.common.geoserverinterface.json.JSONException;
import org.gcube.common.geoserverinterface.json.JSONObject;


public class GeoserverPutMethods {
	
	/**
	 * @uml.property  name="hMC"
	 * @uml.associationEnd  multiplicity="(1 1)"
	 */
	private HttpMethodCall HMC= null;
	
	public GeoserverPutMethods(HttpMethodCall hMC) {
		super();
		HMC = hMC;
	}
	
	public boolean addLayersGroup(GroupRest group) throws Exception {
		
		Map<String, Object> m = new HashMap<String, Object>();
		m.put("name", group.getName());
		
		{
			JSONArray a = new JSONArray();
			for (String layer: group.getLayers()) {
				JSONObject n = new JSONObject();
				n.put("name",layer);
				a.put(n);
			}
			JSONObject l = new JSONObject();
			l.put("layer",a);
			m.put("layers", l);
		}
		{
			JSONArray a = new JSONArray();
			for (String style: group.getStyles()) {
				JSONObject n = new JSONObject();
				n.put("name",style);
				a.put(n);
			}
			JSONObject l = new JSONObject();
			l.put("style",a);
			m.put("styles", l);
		}
		{
			JSONObject bounds = new JSONObject();
			bounds.put("minx", group.getBounds().getMinx());
			bounds.put("maxx", group.getBounds().getMaxx());
			bounds.put("miny", group.getBounds().getMiny());
			bounds.put("maxy", group.getBounds().getMaxy());
			bounds.put("crs", group.getBounds().getCrs());
			
			m.put("bounds", bounds);
			
		}
		
		JSONObject j = new JSONObject();
		j.put("layerGroup", m);
		
		HMC.CallPost("rest/layergroups", j.toString(), "application/json");
		
		return true;
	}
	
	public boolean addFeatureType(FeatureTypeRest featureTypeRest) throws Exception {
		
		Map<String, Object> m = new HashMap<String, Object>();
		m.put("name", featureTypeRest.getName());
		m.put("nativeName", featureTypeRest.getNativeName());
		m.put("title", featureTypeRest.getTitle());
		//m.put("nativeCRS", featureTypeRest.getNativeCRS());
		m.put("srs", featureTypeRest.getSrs());
		m.put("projectionPolicy", featureTypeRest.getProjectionPolicy());
		m.put("enabled", featureTypeRest.isEnabled());
		
		{
			JSONObject bounds = new JSONObject();
			bounds.put("minx", featureTypeRest.getNativeBoundingBox().getMinx());
			bounds.put("maxx", featureTypeRest.getNativeBoundingBox().getMaxx());
			bounds.put("miny", featureTypeRest.getNativeBoundingBox().getMiny());
			bounds.put("maxy", featureTypeRest.getNativeBoundingBox().getMaxy());
			bounds.put("crs", featureTypeRest.getNativeBoundingBox().getCrs());
			
			m.put("nativeBoundingBox", bounds);
			
		}
		
		{
			JSONObject bounds = new JSONObject();
			bounds.put("minx", featureTypeRest.getLatLonBoundingBox().getMinx());
			bounds.put("maxx", featureTypeRest.getLatLonBoundingBox().getMaxx());
			bounds.put("miny", featureTypeRest.getLatLonBoundingBox().getMiny());
			bounds.put("maxy", featureTypeRest.getLatLonBoundingBox().getMaxy());
			bounds.put("crs", featureTypeRest.getLatLonBoundingBox().getCrs());
			
			m.put("latLonBoundingBox", bounds);
			
		}
		/*
		{"featureType":
			{"name":"world",
				"nativeName":"world",
				"namespace":{	"name":"aquamaps",
								"href":"http:\/\/geoserver.d4science-ii.research-infrastructures.eu:8080\/geoserver\/rest\/namespaces\/aquamaps.json"
							},
				"title":"world",
				"nativeCRS":"GEOGCS[\"WGS 84\", \n  DATUM[\"World Geodetic System 1984\", \n    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], \n    AUTHORITY[\"EPSG\",\"6326\"]], \n  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n  UNIT[\"degree\", 0.017453292519943295], \n  AXIS[\"Geodetic longitude\", EAST], \n  AXIS[\"Geodetic latitude\", NORTH], \n  AUTHORITY[\"EPSG\",\"4326\"]]",
				"srs":"EPSG:4326",
				"nativeBoundingBox":{"minx":-180,"maxx":180,"miny":-85.5,"maxy":90,"crs":"EPSG:4326"},
				"latLonBoundingBox":{"minx":-180,"maxx":180,"miny":-85.5,"maxy":90,"crs":"EPSG:4326"},
				"projectionPolicy":"FORCE_DECLARED",
				"enabled":true,
				"store":{"@class":"dataStore",
						"name":"aquamapsdb",
						"href":"http:\/\/geoserver.d4science-ii.research-infrastructures.eu:8080\/geoserver\/rest\/workspaces\/aquamaps\/datastores\/aquamapsdb.json"},"maxFeatures":0,"numDecimals":0}}

		*/
		JSONObject j = new JSONObject();
		j.put("featureType", m);
		HMC.CallPost("rest/workspaces/"+featureTypeRest.getWorkspace()+"/datastores/"+featureTypeRest.getDatastore()+"/featuretypes", j.toString(), "application/json");
		
		/**
		 * Add by Francesco
		 */
		
		//Polling on feature type  
		if(HMC.isAvailableFeatureType("rest/workspaces/"+featureTypeRest.getWorkspace()+"/datastores/"+featureTypeRest.getDatastore()+"/featuretypes/" + featureTypeRest.getName() + ".json", 1, 8))
			return true;
		else
			return false; //feature type not found
				
	}
	
	public boolean addLayer(LayerRest layerRest) throws Exception {
		Map<String, Object> m = new HashMap<String, Object>();
		m.put("name", layerRest.getName());
		m.put("type", layerRest.getName());
		m.put("enabled", layerRest.isEnabled());

		{
			JSONObject defaultStyle = new JSONObject();
			defaultStyle.put("name", layerRest.getDefaultStyle());
			m.put("defaultStyle", defaultStyle);
		}
		
		if (layerRest.getStyles().size() > 0) {
			JSONArray a = new JSONArray();
			for (String layer: layerRest.getStyles()) {
				JSONObject n = new JSONObject();
				n.put("name",layer);
				a.put(n);
			}
			JSONObject l = new JSONObject();
			l.put("style",a);
			m.put("styles", l);
		}
		
		JSONObject j = new JSONObject();
		j.put("layer", m);
		HMC.CallPut("rest/layers/"+ layerRest.getName(), j.toString(), "application/json");
		return true;
	}
	
	public boolean setLayer(FeatureTypeRest featureTypeRest, String defaultStyle, ArrayList<String> styles) throws Exception {
		Map<String, Object> m = new HashMap<String, Object>();
		m.put("name", featureTypeRest.getName());
		m.put("enabled", featureTypeRest.isEnabled());

		{
			JSONObject defStyle = new JSONObject();
			defStyle.put("name", defaultStyle);
			m.put("defaultStyle", defStyle);
		}
		
		if (styles.size() > 0) {
			JSONArray a = new JSONArray();
			for (String layer: styles) {
				JSONObject n = new JSONObject();
				n.put("name",layer);
				a.put(n);
			}
			JSONObject l = new JSONObject();
			l.put("style",a);
			m.put("styles", l);
		}
		
		JSONObject j = new JSONObject();
		j.put("layer", m);
		HMC.CallPut("rest/layers/"+ featureTypeRest.getName(), j.toString(), "application/json");
		return true;
	}
	
	public boolean addStyleToLayer(String layer, String style) throws Exception {
		JSONObject n = new JSONObject();
		n.put("name",style);
		JSONObject j2 = new JSONObject();
		j2.put("style", n);
		
		HMC.CallPost("rest/layers/"+ layer + "/styles", j2.toString(), "application/json");
		return true;
	}
	
	public boolean sendStyleSDL(String xmlSdl) throws Exception {
		
		if (HMC.CallPost("rest/styles", xmlSdl, "application/vnd.ogc.sld+xml") == null) return false;
        return true;
	}

}
