/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.gcube.common.geoserverinterface.Constants;
import org.gcube.common.geoserverinterface.HttpResourceControl;
import org.gcube.common.geoserverinterface.Logger;

public class HttpMethodCall {
    private static final int TIME_OUT_REQUESTS = Constants.getConnectionTimeOut();
    private String urlservice = "";
    private HttpClient client = null;
    private GetMethod methodStream = null;
    private String username = "";
    private String password = "";

    public HttpMethodCall(MultiThreadedHttpConnectionManager connectionManager, String url_service, String user, String password) {
        this.urlservice = url_service;
        connectionManager.getParams().setSoTimeout(TIME_OUT_REQUESTS);
        this.client = new HttpClient((HttpConnectionManager)connectionManager);
        this.username = user;
        this.password = password;
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(user, password);
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
    }

    public String Call(String url_method) throws Exception {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        return this.Call(url_method, tmp);
    }

    public String Call(String url_method, Map<String, Object> get_parameters) throws Exception {
        ArrayList<Object> fixed_tmp = new ArrayList<Object>();
        return this.Call(url_method, fixed_tmp, get_parameters);
    }

    public String Call(String url_method, ArrayList<Object> fixed_parameters, Map<String, Object> get_parameters) throws Exception {
        GetMethod method = new GetMethod(String.valueOf(this.urlservice) + "/" + url_method);
        Logger.info("call .... " + this.urlservice + "/" + url_method);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        String str_fix_parameters = "";
        if (fixed_parameters.size() > 0) {
            int i = 0;
            while (i < fixed_parameters.size()) {
                String param = null;
                param = fixed_parameters.get(i).getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)fixed_parameters.get(i)).booleanValue() ? "1" : "0") : (fixed_parameters.get(i).getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)fixed_parameters.get(i)) : (String)fixed_parameters.get(i));
                str_fix_parameters = String.valueOf(str_fix_parameters) + "/" + param;
                ++i;
            }
            try {
                method.setURI((URI)new HttpURL(String.valueOf(this.urlservice) + "/" + url_method + str_fix_parameters));
            }
            catch (URIException e) {
                e.printStackTrace();
            }
        }
        NameValuePair[] array_get_parameters = new NameValuePair[get_parameters.size()];
        if (get_parameters.size() > 0) {
            int i = 0;
            for (Map.Entry<String, Object> entry : get_parameters.entrySet()) {
                NameValuePair p;
                String param = null;
                param = entry.getValue().getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)entry.getValue()).booleanValue() ? "1" : "0") : (entry.getValue().getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)entry.getValue()) : (entry.getValue().getClass().getSimpleName().contentEquals("Long") ? Long.toString((Long)entry.getValue()) : (String)entry.getValue()));
                array_get_parameters[i] = p = new NameValuePair(entry.getKey(), param);
                ++i;
            }
            method.setQueryString(array_get_parameters);
        }
        byte[] responseBody = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                Logger.error("Method failed: " + method.getStatusLine());
                method.releaseConnection();
                throw new Exception("Method failed: " + method.getStatusLine());
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            Logger.error("Fatal protocol violation: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            Logger.error("Fatal transport error: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
        method.releaseConnection();
        return new String(responseBody);
    }

    public InputStream CallAsStream(String url_method, Map<String, Object> get_parameters) throws Exception {
        ArrayList<Object> fixed_tmp = new ArrayList<Object>();
        return this.CallAsStream(url_method, fixed_tmp, get_parameters);
    }

    public InputStream CallAsStream(String url_method) throws Exception {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        return this.CallAsStream(url_method, tmp);
    }

    public InputStream CallAsStream(String url_method, ArrayList<Object> fixed_parameters, Map<String, Object> get_parameters) throws Exception {
        int statusCode;
        this.methodStream = new GetMethod(String.valueOf(this.urlservice) + "/" + url_method);
        Logger.info("call as stream .... " + this.urlservice + "/" + url_method);
        this.methodStream.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        String str_fix_parameters = "";
        if (fixed_parameters.size() > 0) {
            int i = 0;
            while (i < fixed_parameters.size()) {
                String param = null;
                param = fixed_parameters.get(i).getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)fixed_parameters.get(i)).booleanValue() ? "1" : "0") : (fixed_parameters.get(i).getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)fixed_parameters.get(i)) : (String)fixed_parameters.get(i));
                str_fix_parameters = String.valueOf(str_fix_parameters) + "/" + param;
                ++i;
            }
            try {
                this.methodStream.setURI((URI)new HttpURL(String.valueOf(this.urlservice) + "/" + url_method + str_fix_parameters));
            }
            catch (URIException e) {
                e.printStackTrace();
            }
        }
        NameValuePair[] array_get_parameters = new NameValuePair[get_parameters.size()];
        if (get_parameters.size() > 0) {
            int i = 0;
            for (Map.Entry<String, Object> entry : get_parameters.entrySet()) {
                NameValuePair p;
                String param = null;
                param = entry.getValue().getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)entry.getValue()).booleanValue() ? "1" : "0") : (entry.getValue().getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)entry.getValue()) : (String)entry.getValue());
                array_get_parameters[i] = p = new NameValuePair(entry.getKey(), param);
                ++i;
            }
            this.methodStream.setQueryString(array_get_parameters);
        }
        if ((statusCode = this.client.executeMethod((HttpMethod)this.methodStream)) != 200) {
            Logger.error("Method failed: " + this.methodStream.getStatusLine());
            this.methodStream.releaseConnection();
            throw new Exception("Method failed: " + this.methodStream.getStatusLine());
        }
        return this.methodStream.getResponseBodyAsStream();
    }

    public void releaseConnectionStream() {
        this.methodStream.releaseConnection();
    }

    public String CallPost(String url_method, String body, Map<String, Object> Postparameters, String content_type) throws Exception {
        PostMethod method = new PostMethod(String.valueOf(this.urlservice) + "/" + url_method);
        int i = 0;
        for (Map.Entry<String, Object> entry : Postparameters.entrySet()) {
            String param = null;
            param = entry.getValue().getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)entry.getValue()).booleanValue() ? "1" : "0") : (entry.getValue().getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)entry.getValue()) : (String)entry.getValue());
            method.getParams().setParameter(entry.getKey(), (Object)param);
            ++i;
        }
        method.setRequestHeader("Content-type", content_type);
        Logger.info("call post .... " + this.urlservice + "/" + url_method);
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.getBytes()));
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        byte[] responseBody = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200 && statusCode != 201) {
                Logger.error("Method failed: " + method.getStatusLine());
                method.releaseConnection();
                throw new Exception("Method failed: " + method.getStatusLine());
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            Logger.error("Fatal protocol violation: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            Logger.error("Fatal transport error: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
        method.releaseConnection();
        return new String(responseBody);
    }

    public String CallPost(String url_method, String body, String content_type) throws Exception {
        PostMethod method = new PostMethod(String.valueOf(this.urlservice) + "/" + url_method);
        method.setRequestHeader("Content-type", content_type);
        Logger.info("call post .... " + this.urlservice + "/" + url_method);
        Logger.debug("\tcall post body.... " + body);
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.getBytes()));
        byte[] responseBody = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200 && statusCode != 201) {
                Logger.error("Method failed: " + method.getStatusLine());
                method.releaseConnection();
                throw new Exception("Method failed: " + method.getStatusLine());
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            Logger.error("Fatal protocol violation: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (Exception e) {
            Logger.error("Fatal transport error: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
        method.releaseConnection();
        return new String(responseBody);
    }

    public String CallPost(String url_method, Map<String, Object> Postparameters, String content_type) throws Exception {
        PostMethod method = new PostMethod(String.valueOf(this.urlservice) + "/" + url_method);
        method.setRequestHeader("Content-type", content_type);
        Logger.info("call post .... " + this.urlservice + "/" + url_method);
        NameValuePair[] array_parameters = new NameValuePair[Postparameters.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : Postparameters.entrySet()) {
            NameValuePair p;
            String param = null;
            param = entry.getValue().getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)entry.getValue()).booleanValue() ? "1" : "0") : (entry.getValue().getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)entry.getValue()) : (String)entry.getValue());
            array_parameters[i] = p = new NameValuePair(entry.getKey(), param);
            ++i;
        }
        method.setRequestBody(array_parameters);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        byte[] responseBody = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                Logger.error("Method failed: " + method.getStatusLine());
                method.releaseConnection();
                throw new Exception("Method failed: " + method.getStatusLine());
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            Logger.error("Fatal protocol violation: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            Logger.error("Fatal transport error: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
        method.releaseConnection();
        return new String(responseBody);
    }

    public String CallPut(String url_method, String body, String content_type) throws Exception {
        PutMethod method = new PutMethod(String.valueOf(this.urlservice) + "/" + url_method);
        method.setRequestHeader("Content-type", content_type);
        Logger.info("call put .... " + this.urlservice + "/" + url_method);
        method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(body.getBytes()));
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        byte[] responseBody = null;
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                Logger.error("Method error: " + method.getStatusLine());
                Logger.error(method.getStatusText());
                method.releaseConnection();
                throw new Exception("Method error: " + method.getStatusLine());
            }
            responseBody = method.getResponseBody();
        }
        catch (HttpException e) {
            Logger.error("Fatal protocol violation: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            Logger.error("Fatal transport error: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
        method.releaseConnection();
        return new String(responseBody);
    }

    public InputStream CallStreaming(String url_method, ArrayList<Object> fixed_parameters, Map<String, Object> get_parameters) throws Exception {
        GetMethod method = new GetMethod(String.valueOf(this.urlservice) + "/" + url_method);
        Logger.info("call as stream .... " + this.urlservice + "/" + url_method);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        String str_fix_parameters = "";
        if (fixed_parameters.size() > 0) {
            int i = 0;
            while (i < fixed_parameters.size()) {
                String param = null;
                param = fixed_parameters.get(i).getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)fixed_parameters.get(i)).booleanValue() ? "1" : "0") : (fixed_parameters.get(i).getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)fixed_parameters.get(i)) : (String)fixed_parameters.get(i));
                str_fix_parameters = String.valueOf(str_fix_parameters) + "/" + param;
                ++i;
            }
            try {
                method.setURI((URI)new HttpURL(String.valueOf(this.urlservice) + "/" + url_method + str_fix_parameters));
            }
            catch (URIException e) {
                e.printStackTrace();
            }
        }
        NameValuePair[] array_get_parameters = new NameValuePair[get_parameters.size()];
        if (get_parameters.size() > 0) {
            int i = 0;
            for (Map.Entry<String, Object> entry : get_parameters.entrySet()) {
                NameValuePair p;
                String param = null;
                param = entry.getValue().getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)entry.getValue()).booleanValue() ? "1" : "0") : (entry.getValue().getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)entry.getValue()) : (String)entry.getValue());
                array_get_parameters[i] = p = new NameValuePair(entry.getKey(), param);
                ++i;
            }
            method.setQueryString(array_get_parameters);
        }
        try {
            int statusCode = this.client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                Logger.error("Method failed: " + method.getStatusLine());
                method.releaseConnection();
                throw new Exception("Method error: " + method.getStatusLine());
            }
            return method.getResponseBodyAsStream();
        }
        catch (HttpException e) {
            Logger.error("Fatal protocol violation: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            Logger.error("Fatal transport error: " + e.getMessage());
            e.printStackTrace();
            method.releaseConnection();
            throw new Exception("Fatal transport error: " + e.getMessage());
        }
    }

    public void setTimeOut(int timeout) {
        this.client.getParams().setConnectionManagerTimeout((long)timeout);
    }

    public Boolean CallDelete(String url_method) throws Exception {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        return this.CallDelete(url_method, tmp);
    }

    public static String authenticationBase64(String username, String password) {
        String authString = String.valueOf(username) + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        return authString;
    }

    public boolean deleteStyle(String urlString) throws Exception {
        URL url = new URL(String.valueOf(this.urlservice) + "/" + urlString);
        String authString = HttpMethodCall.authenticationBase64(this.username, this.password);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Authorization", "Basic " + authString);
        con.setRequestMethod("DELETE");
        if (this.username != null && this.username.trim().length() > 0) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(HttpMethodCall.this.username, HttpMethodCall.this.password.toCharArray());
                }
            });
        }
        Logger.info("..deleting Style " + urlString + " " + con.getResponseCode());
        switch (con.getResponseCode()) {
            case 200: {
                return true;
            }
        }
        Logger.error("Bad response from GS: code[" + con.getResponseCode() + "] msg[" + con.getResponseMessage() + "]");
        return false;
    }

    public Boolean CallDelete(String url_method, Map<String, Object> parameters) throws Exception {
        DeleteMethod method = new DeleteMethod(String.valueOf(this.urlservice) + "/" + url_method);
        int i = 0;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String param = null;
            param = entry.getValue().getClass().getSimpleName().contentEquals("Boolean") ? (((Boolean)entry.getValue()).booleanValue() ? "1" : "0") : (entry.getValue().getClass().getSimpleName().contentEquals("Integer") ? Integer.toString((Integer)entry.getValue()) : (String)entry.getValue());
            String key = entry.getKey();
            method.getParams().setParameter(key, (Object)param);
            ++i;
        }
        Logger.info("call delete ... " + this.urlservice + "/" + url_method);
        int status = -1;
        try {
            try {
                status = this.client.executeMethod((HttpMethod)method);
            }
            catch (Exception e) {
                Logger.error("DELETE Failed (" + status + ")," + e);
                method.releaseConnection();
                throw new Exception("DELETE Failed (" + status + ")," + e);
            }
        }
        finally {
            method.releaseConnection();
        }
        return true;
    }

    public String getUrlservice() {
        return this.urlservice;
    }

    public void setUrlservice(String urlservice) {
        this.urlservice = urlservice;
    }

    public boolean isAvailableFeatureType(String featureTypeUrl, int trySleepTimeSc, int maxTry) {
        String url = String.valueOf(this.urlservice) + "/" + featureTypeUrl;
        HttpResourceControl httpRC = new HttpResourceControl();
        return httpRC.isAvailableNetworkResource(url, trySleepTimeSc, maxTry, this.username, this.password);
    }

    private String getServiceUrl() {
        return this.urlservice;
    }
}

