/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.engine;

import java.util.HashMap;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.engine.GeoserverGetMethods;
import org.gcube.common.geoserverinterface.json.JSONArray;
import org.gcube.common.geoserverinterface.json.JSONObject;

public class GeoserverModifyMethods {
    private HttpMethodCall HMC = null;
    private GeoserverGetMethods geoserverGetMethods;

    public GeoserverModifyMethods(HttpMethodCall hMC) {
        this.HMC = hMC;
        this.geoserverGetMethods = new GeoserverGetMethods(hMC);
    }

    public boolean modifyLayersGroup(GroupRest group) throws Exception {
        JSONObject bounds;
        JSONObject l;
        JSONObject n;
        JSONArray a;
        HashMap<String, JSONObject> m = new HashMap<String, JSONObject>();
        GroupRest tmp = this.geoserverGetMethods.getLayerGroup(group.getName());
        if (group.getLayers().size() > 0) {
            a = new JSONArray();
            for (String layer : group.getLayers()) {
                n = new JSONObject();
                n.put("name", layer);
                a.put(n);
            }
            l = new JSONObject();
            l.put("layer", a);
            m.put("layers", l);
        } else {
            a = new JSONArray();
            for (String layer : tmp.getLayers()) {
                n = new JSONObject();
                n.put("name", layer);
                a.put(n);
            }
            l = new JSONObject();
            l.put("layer", a);
            m.put("layers", l);
        }
        if (group.getStyles().size() > 0) {
            a = new JSONArray();
            for (String style : group.getStyles()) {
                n = new JSONObject();
                n.put("name", style);
                a.put(n);
            }
            l = new JSONObject();
            l.put("style", a);
            m.put("styles", l);
        } else {
            a = new JSONArray();
            for (String style : tmp.getStyles()) {
                n = new JSONObject();
                n.put("name", style);
                a.put(n);
            }
            l = new JSONObject();
            l.put("style", a);
            m.put("styles", l);
        }
        if (group.getBounds() != null) {
            bounds = new JSONObject();
            bounds.put("minx", group.getBounds().getMinx());
            bounds.put("maxx", group.getBounds().getMaxx());
            bounds.put("miny", group.getBounds().getMiny());
            bounds.put("maxy", group.getBounds().getMaxy());
            bounds.put("crs", group.getBounds().getCrs());
            m.put("bounds", bounds);
        } else {
            bounds = new JSONObject();
            bounds.put("minx", tmp.getBounds().getMinx());
            bounds.put("maxx", tmp.getBounds().getMaxx());
            bounds.put("miny", tmp.getBounds().getMiny());
            bounds.put("maxy", tmp.getBounds().getMaxy());
            bounds.put("crs", tmp.getBounds().getCrs());
            m.put("bounds", bounds);
        }
        JSONObject j = new JSONObject();
        j.put("layerGroup", m);
        this.HMC.CallPut("rest/layergroups/" + group.getName(), j.toString(), "application/json");
        return true;
    }

    public boolean modifyStyleSDL(String schemaName, String xmlSdl) throws Exception {
        return this.HMC.CallPut("rest/styles/" + schemaName, xmlSdl, "application/vnd.ogc.sld+xml") != null;
    }
}

