/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.geonetwork.csw;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.geoserverinterface.bean.MetadataInfo;
import org.gcube.common.geoserverinterface.geonetwork.csw.AbstractXmlISO19139;
import org.gcube.common.geoserverinterface.geonetwork.csw.NamespaceCswResolver;
import org.gcube.common.geoserverinterface.geonetwork.utils.DateTimeIso8601;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MetadataISO19139
extends AbstractXmlISO19139 {
    private DocumentBuilderFactory dbfac;
    private DocumentBuilder docBuilder;
    private Document doc;
    private NamespaceCswResolver nms;
    private String title;
    private String fileIdentifier;
    private String name;
    private String description;
    private String url;
    private String abst;
    private String categoryCode;
    private String westBoundLongitude;
    private String eastBoundLongitude;
    private String southBoundLongitude;
    private String northBoundLongitude;
    private String language;
    private Element gmdMD_Metadata;
    private final String xmlns = "xmlns:";
    private final String xsi = "xsi:";
    private String standardName = "ISO 19115:2003/19139";
    private String standardVersion = "1.0";
    private String nilReason = "nilReason";
    private String valueNilReason = "missing";
    private String protocol = "OGC:WMS-1.1.1-http-get-map";

    public MetadataISO19139(String fileIdentifier, String title, String name, String description, String url) {
        this.fileIdentifier = fileIdentifier;
        this.title = title;
        this.name = name;
        this.description = description;
        this.url = url;
        this.nms = new NamespaceCswResolver();
    }

    public MetadataISO19139(MetadataInfo metadataInfo) {
        this.fileIdentifier = metadataInfo.getFileIdentifier();
        this.title = metadataInfo.getTitle();
        this.name = metadataInfo.getName();
        this.description = metadataInfo.getDescription();
        this.url = metadataInfo.getUrl();
        this.westBoundLongitude = metadataInfo.getWestBoundLongitude();
        this.eastBoundLongitude = metadataInfo.getEastBoundLongitude();
        this.southBoundLongitude = metadataInfo.getSouthBoundLongitude();
        this.northBoundLongitude = metadataInfo.getNorthBoundLongitude();
        this.abst = metadataInfo.getAbst();
        this.language = metadataInfo.getLanguage();
        this.categoryCode = metadataInfo.getCategoryCode();
        this.nms = new NamespaceCswResolver();
    }

    private void instanceDOM() {
        this.dbfac = DocumentBuilderFactory.newInstance();
        try {
            this.docBuilder = this.dbfac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.doc = this.docBuilder.newDocument();
    }

    private void createISO19139() {
        this.instanceDOM();
        this.gmdMD_Metadata = this.createISOHeader();
        this.gmdMD_Metadata.appendChild(this.createIdentificationInfo());
        this.gmdMD_Metadata.appendChild(this.createDistributionInfo());
        this.gmdMD_Metadata.appendChild(this.createDataQualityInfo());
    }

    public String getISO19139() {
        this.createISO19139();
        String xmlString = new String();
        TransformerFactory transfac = TransformerFactory.newInstance();
        try {
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
            xmlString = sw.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    private Element createISOHeader() {
        Element gmdMD_Metadata = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_Metedata());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixGMD(), this.nms.getNamespaceGMD());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixGTS(), this.nms.getNamespaceGTS());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixXSI(), this.nms.getNamespaceXSI());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixGML(), this.nms.getNamespaceGML());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixGCO(), this.nms.getNamespaceGCO());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixXLINK(), this.nms.getNamespaceXLINK());
        gmdMD_Metadata.setAttribute("xmlns:" + this.nms.getPrefixGEONET(), this.nms.getNamespaceGEONET());
        gmdMD_Metadata.setAttribute("xsi:schemaLocation", "http://www.isotc211.org/2005/gmd http://www.isotc211.org/2005/gmd/gmd.xsd");
        this.doc.appendChild(gmdMD_Metadata);
        Element gmdFileIdentifier = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagFileIdentifier());
        gmdFileIdentifier.setAttribute("xmlns:" + this.nms.getPrefixGMX(), this.nms.getNamespaceGMX());
        gmdFileIdentifier.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        Element gcoCharacterString = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text = this.doc.createTextNode(this.fileIdentifier);
        gcoCharacterString.appendChild(text);
        gmdFileIdentifier.appendChild(gcoCharacterString);
        gmdMD_Metadata.appendChild(gmdFileIdentifier);
        Element gmdLanguage = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagLanguage());
        Element gcoCharacterString2 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text2 = this.doc.createTextNode(this.language);
        gcoCharacterString2.appendChild(text2);
        gmdLanguage.appendChild(gcoCharacterString2);
        gmdMD_Metadata.appendChild(gmdLanguage);
        Element gmdCharacterSet = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCharacterSet());
        Element gmdMD_CharacterSetCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_CharacterSetCode());
        gmdMD_CharacterSetCode.setAttribute(this.getAttrCodeList(), this.getValueAttrMD_CharacterSetCodeCodeList());
        gmdMD_CharacterSetCode.setAttribute(this.getAttrCodeListValue(), this.getValueAttrMD_CharacterSetCodeCodeListValue());
        gmdCharacterSet.appendChild(gmdMD_CharacterSetCode);
        gmdMD_Metadata.appendChild(gmdCharacterSet);
        Element gmdHierarchyLevel = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagHierarchyLevel());
        Element gmdMD_ScopeCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_ScopeCode());
        gmdMD_ScopeCode.setAttribute(this.getAttrCodeList(), this.getValueAttrMD_ScopeCodeCodeList());
        gmdMD_ScopeCode.setAttribute(this.getAttrCodeListValue(), this.getValueAttrMD_ScopeCodeCodeListValue());
        gmdHierarchyLevel.appendChild(gmdMD_ScopeCode);
        gmdMD_Metadata.appendChild(gmdHierarchyLevel);
        Element gmdDateStamp = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagdDateStamp());
        Element gcoDateTime = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagDateTime());
        Text text3 = this.doc.createTextNode(DateTimeIso8601.formatDateTime());
        gcoDateTime.appendChild(text3);
        gmdDateStamp.appendChild(gcoDateTime);
        gmdMD_Metadata.appendChild(gmdDateStamp);
        Element gmdMetadataStandardName = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMetadataStandardName());
        Element gcoCharacterString3 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text4 = this.doc.createTextNode(this.standardName);
        gcoCharacterString3.appendChild(text4);
        gmdMetadataStandardName.appendChild(gcoCharacterString3);
        gmdMD_Metadata.appendChild(gmdMetadataStandardName);
        Element gmdMetadataStandardVersion = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMetadataStandardVersion());
        Element gcoCharacterString4 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text5 = this.doc.createTextNode(this.standardVersion);
        gcoCharacterString4.appendChild(text5);
        gmdMetadataStandardVersion.appendChild(gcoCharacterString4);
        gmdMD_Metadata.appendChild(gmdMetadataStandardVersion);
        return gmdMD_Metadata;
    }

    private Element createIdentificationInfo() {
        Element gmdIdentificationInfo = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagIdentificationInfo());
        Element gmdMD_DataIdentification = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_DataIdentification());
        Element gmdCitation = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCitation());
        gmdCitation.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        gmdCitation.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        Element gmdCI_Citation = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCI_Citation());
        Element gmdTitle = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagTitle());
        Element gcoCharacterString = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text = this.doc.createTextNode(this.title);
        gcoCharacterString.appendChild(text);
        gmdTitle.appendChild(gcoCharacterString);
        gmdCI_Citation.appendChild(gmdTitle);
        Element gmdDate = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDate());
        Element gmdCI_Date = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCI_Date());
        Element gmdDate2 = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDate());
        Element gmdDateTime = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagDateTime());
        Text text2 = this.doc.createTextNode(DateTimeIso8601.formatDateTime());
        gmdDateTime.appendChild(text2);
        gmdDate2.appendChild(gmdDateTime);
        gmdCI_Date.appendChild(gmdDate2);
        Element gmdDateType = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDateType());
        Element gmdCI_DateTypeCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCI_DateTypeCode());
        gmdCI_DateTypeCode.setAttribute(this.getAttrCodeList(), this.getValueAttrCI_DateTypeCodeCodeList());
        gmdCI_DateTypeCode.setAttribute(this.getAttrCodeListValue(), this.getValueAttrCI_DateTypeCodeCodeListValue());
        gmdDateType.appendChild(gmdCI_DateTypeCode);
        gmdCI_Date.appendChild(gmdDateType);
        gmdDate.appendChild(gmdCI_Date);
        gmdCI_Citation.appendChild(gmdDate);
        gmdCitation.appendChild(gmdCI_Citation);
        gmdMD_DataIdentification.appendChild(gmdCitation);
        Element gmdAbstract = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagAbstract());
        gmdAbstract.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        gmdAbstract.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        Element gcoCharacterString2 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text3 = this.doc.createTextNode(this.abst);
        gcoCharacterString2.appendChild(text3);
        gmdAbstract.appendChild(gcoCharacterString2);
        gmdMD_DataIdentification.appendChild(gmdAbstract);
        Element gmdStatus = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagStatus());
        gmdStatus.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        gmdStatus.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        Element gmdMD_ProgressCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_ProgressCode());
        gmdMD_ProgressCode.setAttribute(this.getAttrCodeList(), this.getValueAttrMD_ProgressCodeCodeList());
        gmdMD_ProgressCode.setAttribute(this.getAttrCodeListValue(), this.getValueAttrMD_ProgressCodeCodeListValue());
        gmdStatus.appendChild(gmdMD_ProgressCode);
        gmdMD_DataIdentification.appendChild(gmdStatus);
        Element gmdLanguage = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagLanguage());
        gmdLanguage.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        gmdLanguage.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        gmdLanguage.setAttribute(this.nms.getPrefixGCO() + ":" + this.nilReason, this.valueNilReason);
        Element gcoCharacterString3 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        gmdLanguage.appendChild(gcoCharacterString3);
        gmdMD_DataIdentification.appendChild(gmdLanguage);
        Element gmdCharacterSet = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCharacterSet());
        gmdCharacterSet.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        gmdCharacterSet.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        Element gmdMD_CharacterSetCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_CharacterSetCode());
        gmdMD_CharacterSetCode.setAttribute(this.getAttrCodeList(), this.getValueAttrMD_CharacterSetCodeCodeListLanguage());
        gmdMD_CharacterSetCode.setAttribute(this.getAttrCodeListValue(), "");
        gmdCharacterSet.appendChild(gmdMD_CharacterSetCode);
        gmdMD_DataIdentification.appendChild(gmdCharacterSet);
        Element gmdTopicCategory = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagTopicCategory());
        gmdTopicCategory.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        gmdTopicCategory.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        Element gmdMD_TopicCategoryCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_TopicCategoryCode());
        Text text4 = this.doc.createTextNode(this.categoryCode);
        gmdMD_TopicCategoryCode.appendChild(text4);
        gmdTopicCategory.appendChild(gmdMD_TopicCategoryCode);
        gmdMD_DataIdentification.appendChild(gmdTopicCategory);
        Element gmdExtent = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagExtent());
        gmdExtent.setAttribute("xmlns:" + this.nms.getPrefixSRV(), this.nms.getNamespaceSRV());
        gmdExtent.setAttribute("xmlns:" + this.nms.getPrefixWMS(), this.nms.getNamespaceWMS());
        Element gmdEX_Extent = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagEX_Extent());
        Element gmdGeographicElement = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagGeographicElement());
        Element gmdEX_GeographicBoundingBox = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagEX_GeographicBoundingBox());
        Element gmdWestBoundLongitude = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagWestBoundLongitude());
        Element gcoDecimal = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagDecimal());
        Text text5 = this.doc.createTextNode(this.westBoundLongitude);
        gcoDecimal.appendChild(text5);
        gmdWestBoundLongitude.appendChild(gcoDecimal);
        gmdEX_GeographicBoundingBox.appendChild(gmdWestBoundLongitude);
        Element gmdEastBoundLongitude = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagEastBoundLongitude());
        Element gcoDecimal2 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagDecimal());
        Text text6 = this.doc.createTextNode(this.eastBoundLongitude);
        gcoDecimal2.appendChild(text6);
        gmdEastBoundLongitude.appendChild(gcoDecimal2);
        gmdEX_GeographicBoundingBox.appendChild(gmdEastBoundLongitude);
        Element gmdSouthBoundLatitude = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagSouthBoundLatitude());
        Element gcoDecimal3 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagDecimal());
        Text text7 = this.doc.createTextNode(this.southBoundLongitude);
        gcoDecimal3.appendChild(text7);
        gmdSouthBoundLatitude.appendChild(gcoDecimal3);
        gmdEX_GeographicBoundingBox.appendChild(gmdSouthBoundLatitude);
        Element gmdNorthBoundLatitude = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagNorthBoundLatitude());
        Element gcoDecimal4 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagDecimal());
        Text text8 = this.doc.createTextNode(this.northBoundLongitude);
        gcoDecimal4.appendChild(text8);
        gmdNorthBoundLatitude.appendChild(gcoDecimal4);
        gmdEX_GeographicBoundingBox.appendChild(gmdNorthBoundLatitude);
        gmdGeographicElement.appendChild(gmdEX_GeographicBoundingBox);
        gmdEX_Extent.appendChild(gmdGeographicElement);
        gmdExtent.appendChild(gmdEX_Extent);
        gmdMD_DataIdentification.appendChild(gmdExtent);
        gmdIdentificationInfo.appendChild(gmdMD_DataIdentification);
        return gmdIdentificationInfo;
    }

    private Element createDistributionInfo() {
        Element gmdDistributionInfo = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDistributionInfo());
        Element gmdMD_Distribution = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_Distribution());
        Element gmdDistributionFormat = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDistributionFormat());
        Element gmdMD_Format = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_Format());
        Element gmdName = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagName());
        gmdName.setAttribute(this.nms.getPrefixGCO() + ":" + this.nilReason, this.valueNilReason);
        Element gcoCharacterString = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        gmdName.appendChild(gcoCharacterString);
        gmdMD_Format.appendChild(gmdName);
        Element gmdVersion = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagVersion());
        gmdVersion.setAttribute(this.nms.getPrefixGCO() + ":" + this.nilReason, this.valueNilReason);
        Element gcoCharacterString2 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        gmdVersion.appendChild(gcoCharacterString2);
        gmdMD_Format.appendChild(gmdVersion);
        gmdDistributionFormat.appendChild(gmdMD_Format);
        gmdMD_Distribution.appendChild(gmdDistributionFormat);
        Element gmdTransferOptions = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagTransferOptions());
        Element gmdMD_DigitalTransferOptions = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_DigitalTransferOptions());
        Element gmdOnLine = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagOnLine());
        Element gmdCI_OnlineResource = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagCI_OnlineResource());
        Element gmdLinkage = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagLinkage());
        Element gmdURL = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagURL());
        Text text = this.doc.createTextNode(this.url);
        gmdURL.appendChild(text);
        gmdLinkage.appendChild(gmdURL);
        gmdCI_OnlineResource.appendChild(gmdLinkage);
        Element gmdProtocol = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagProtocol());
        Element gcoCharacterString3 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text2 = this.doc.createTextNode(this.protocol);
        gcoCharacterString3.appendChild(text2);
        gmdProtocol.appendChild(gcoCharacterString3);
        gmdCI_OnlineResource.appendChild(gmdProtocol);
        Element gmdName2 = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagName());
        Element gcoCharacterString4 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text3 = this.doc.createTextNode(this.name);
        gcoCharacterString4.appendChild(text3);
        gmdName2.appendChild(gcoCharacterString4);
        gmdCI_OnlineResource.appendChild(gmdName2);
        Element gmdDescription = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDescription());
        Element gcoCharacterString5 = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        Text text4 = this.doc.createTextNode(this.description);
        gcoCharacterString5.appendChild(text4);
        gmdDescription.appendChild(gcoCharacterString5);
        gmdCI_OnlineResource.appendChild(gmdDescription);
        gmdOnLine.appendChild(gmdCI_OnlineResource);
        gmdCI_OnlineResource.appendChild(gmdDescription);
        gmdOnLine.appendChild(gmdCI_OnlineResource);
        gmdMD_DigitalTransferOptions.appendChild(gmdOnLine);
        gmdTransferOptions.appendChild(gmdMD_DigitalTransferOptions);
        gmdMD_Distribution.appendChild(gmdTransferOptions);
        gmdDistributionInfo.appendChild(gmdMD_Distribution);
        return gmdDistributionInfo;
    }

    private Element createDataQualityInfo() {
        Element gmdDataQualityInfo = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDataQualityInfo());
        Element gmdDQ_DataQuality = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDQ_DataQuality());
        Element gmdScope = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagScope());
        Element gmdDQ_Scope = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagDQ_Scope());
        Element gmdLevel = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagLevel());
        Element gmdMD_ScopeCode = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagMD_ScopeCode());
        gmdMD_ScopeCode.setAttribute(this.getAttrCodeList(), this.getValueAttrMD_ScopeCodeCodeList());
        gmdMD_ScopeCode.setAttribute(this.getAttrCodeListValue(), this.getValueAttrMD_ScopeCodeCodeListValue());
        gmdLevel.appendChild(gmdMD_ScopeCode);
        gmdDQ_Scope.appendChild(gmdLevel);
        gmdScope.appendChild(gmdDQ_Scope);
        gmdDQ_DataQuality.appendChild(gmdScope);
        Element gmdLineage = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagLineage());
        Element gmdLI_Lineage = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagLI_Lineage());
        Element gmdStatement = this.doc.createElement(this.nms.getPrefixGMD() + ":" + this.getTagStatement());
        gmdStatement.setAttribute(this.nms.getPrefixGCO() + ":" + this.nilReason, this.valueNilReason);
        Element gcoCharacterString = this.doc.createElement(this.nms.getPrefixGCO() + ":" + this.getTagCharacterString());
        gmdStatement.appendChild(gcoCharacterString);
        gmdLI_Lineage.appendChild(gmdStatement);
        gmdLineage.appendChild(gmdLI_Lineage);
        gmdDQ_DataQuality.appendChild(gmdLineage);
        gmdDataQualityInfo.appendChild(gmdDQ_DataQuality);
        return gmdDataQualityInfo;
    }
}

