/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.TextSymbolizer;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.picocontainer.MutablePicoContainer;

public class SLDTextSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDTextSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.TEXTSYMBOLIZER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return TextSymbolizer.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        TextSymbolizer ts = this.styleFactory.createTextSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                ts.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                ts.setGeometry(geometry);
            }
        }
        if (node.hasChild("Label")) {
            ts.setLabel((Expression)node.getChildValue("Label"));
        }
        if (node.hasChild("Font")) {
            ts.setFonts(new Font[]{(Font)node.getChildValue("Font")});
        }
        if (node.hasChild("LabelPlacement")) {
            ts.setPlacement((LabelPlacement)node.getChildValue("LabelPlacement"));
        }
        if (node.hasChild("Halo")) {
            ts.setHalo((Halo)node.getChildValue("Halo"));
        }
        if (node.hasChild("Fill")) {
            ts.setFill((Fill)node.getChildValue("Fill"));
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            ts.getOptions().put(param.getName(), (String)param.getExpression().evaluate(null, String.class));
        }
        return ts;
    }
}

