/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.gml2.GML;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GML2EncodingUtils {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.gml");
    static GMLEncodingUtils e = new GMLEncodingUtils(GML.getInstance());

    public static String epsgCode(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        for (Identifier id : crs.getIdentifiers()) {
            if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
            return id.getCode();
        }
        return null;
    }

    public static String crs(CoordinateReferenceSystem crs) {
        return GML2EncodingUtils.toURI(crs);
    }

    public static String toURI(CoordinateReferenceSystem crs) {
        return GML2EncodingUtils.toURI(crs, false);
    }

    public static String toURI(CoordinateReferenceSystem crs, boolean forceOldStyle) {
        String code = GML2EncodingUtils.epsgCode(crs);
        CRS.AxisOrder axisOrder = CRS.getAxisOrder(crs, true);
        if (code != null) {
            if (forceOldStyle || axisOrder == CRS.AxisOrder.EAST_NORTH || axisOrder == CRS.AxisOrder.INAPPLICABLE) {
                return "http://www.opengis.net/gml/srs/epsg.xml#" + code;
            }
            return "urn:x-ogc:def:crs:EPSG:" + code;
        }
        return null;
    }

    public static CoordinateReferenceSystem getCRS(Geometry g) {
        if (g.getUserData() == null) {
            return null;
        }
        if (g.getUserData() instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)g.getUserData();
        }
        if (g.getUserData() instanceof Map) {
            Map userData = (Map)g.getUserData();
            return (CoordinateReferenceSystem)userData.get(CoordinateReferenceSystem.class);
        }
        return null;
    }

    public static String getID(Geometry g) {
        return e.getMetadata(g, "gml:id");
    }

    public static String getName(Geometry g) {
        return e.getMetadata(g, "gml:name");
    }

    public static String getDescription(Geometry g) {
        return e.getMetadata(g, "gml:description");
    }

    public static Element AbstractFeatureType_encode(Object object, Document document, Element value) {
        Feature feature = (Feature)object;
        FeatureType featureType = feature.getType();
        String namespace = featureType.getName().getNamespaceURI();
        String typeName = featureType.getName().getLocalPart();
        Element encoding = document.createElementNS(namespace, typeName);
        encoding.setAttributeNS(null, "fid", feature.getIdentifier().getID());
        return encoding;
    }

    public static List AbstractFeatureType_getProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Set<String> toFilter, Configuration configuration) {
        return e.AbstractFeatureType_getProperties(object, element, schemaIndex, toFilter, configuration);
    }

    public static XSDTypeDefinition createXmlTypeFromFeatureType(SimpleFeatureType featureType, SchemaIndex schemaIndex, Set<String> toFilter) {
        return e.createXmlTypeFromFeatureType(featureType, schemaIndex, toFilter);
    }

    public static Object GeometryPropertyType_getProperty(Geometry geometry, QName name) {
        return e.GeometryPropertyType_getProperty(geometry, name);
    }

    public static Object GeometryPropertyType_getProperty(Geometry geometry, QName name, boolean includeAbstractGeometry) {
        return e.GeometryPropertyType_getProperty(geometry, name, includeAbstractGeometry);
    }

    public static List GeometryPropertyType_getProperties(Geometry geometry) {
        return e.GeometryPropertyType_getProperties(geometry);
    }
}

