/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.junit.Assume;
import org.junit.Test;
import org.opengis.test.Assert;
import org.opengis.test.TestCase;
import org.opengis.test.Validators;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class NameTest
extends TestCase {
    protected final NameFactory factory;

    protected NameTest(NameFactory nameFactory) {
        this.factory = nameFactory;
    }

    private NameSpace createNameSpace(GenericName genericName, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("separator", string2);
        hashMap.put("separator.head", string);
        return this.factory.createNameSpace(genericName, hashMap);
    }

    @Test
    public void testInternationalString() {
        Assume.assumeNotNull((Object[])new Object[]{this.factory});
        HashMap<Locale, String> hashMap = new HashMap<Locale, String>();
        hashMap.put(Locale.ENGLISH, "My documents");
        hashMap.put(Locale.FRENCH, "Mes documents");
        InternationalString internationalString = this.factory.createInternationalString(hashMap);
        Validators.validate(internationalString);
        for (Map.Entry entry : hashMap.entrySet()) {
            Assert.assertEquals((String)"toString(Locale) should returns the value given to the factory method.", entry.getValue(), (Object)internationalString.toString((Locale)entry.getKey()));
        }
        Assert.assertContains("toString() should returns one of the values given to the factory method.", hashMap.values(), ((Object)internationalString).toString());
    }

    @Test
    public void testLocalName() {
        Assume.assumeNotNull((Object[])new Object[]{this.factory});
        LocalName localName = this.factory.createLocalName(null, "EPSG");
        Validators.validate(localName);
        Assert.assertTrue((boolean)localName.scope().isGlobal());
        Assert.assertEquals((Object)"EPSG", (Object)((Object)localName).toString());
        Assert.assertEquals((Object)"EPSG", (Object)((Object)localName.toInternationalString()).toString());
        NameSpace nameSpace = this.createNameSpace(localName, ":", ":");
        Validators.validate(nameSpace);
        Assert.assertEquals((Object)localName, (Object)nameSpace.name());
        LocalName localName2 = this.factory.createLocalName(nameSpace, "4326");
        Validators.validate(localName2);
        Assert.assertEquals((Object)nameSpace, (Object)localName2.scope());
        Assert.assertEquals((Object)"4326", (Object)((Object)localName2).toString());
        Assert.assertEquals((Object)"EPSG:4326", (Object)((Object)localName2.toFullyQualifiedName()).toString());
    }

    @Test
    public void testScopedName() {
        Assume.assumeNotNull((Object[])new Object[]{this.factory});
        CharSequence[] charSequenceArray = new String[]{"urn", "ogc", "def", "crs", "epsg", "4326"};
        GenericName genericName = this.factory.createGenericName(null, charSequenceArray);
        Validators.validate(genericName);
        Assert.assertEquals((String)"Name should be already fully qualified.", (Object)genericName, (Object)genericName.toFullyQualifiedName());
        Assert.assertTrue((String)"Fully qualified name should be \"urn:ogc:def:crs:epsg:4326\" (separator may vary).", (boolean)Pattern.matches("urn\\p{Punct}ogc\\p{Punct}def\\p{Punct}crs\\p{Punct}epsg\\p{Punct}4326", ((Object)genericName).toString()));
        Assert.assertEquals((String)"Depth shall be counted from the global namespace.", (long)6L, (long)genericName.depth());
        int n = charSequenceArray.length;
        while (--n >= 0) {
            genericName = genericName.tip();
            Validators.validate(genericName);
            Assert.assertEquals((Object)charSequenceArray[n], (Object)((Object)genericName).toString());
            genericName = genericName.scope().name();
        }
    }

    @Test
    public void testParsedURN() {
        Assume.assumeNotNull((Object[])new Object[]{this.factory});
        LocalName localName = this.factory.createLocalName(null, "urn");
        Validators.validate(localName);
        NameSpace nameSpace = this.createNameSpace(localName, ":", ":");
        Validators.validate(nameSpace);
        GenericName genericName = this.factory.parseGenericName(nameSpace, "ogc:def:crs:epsg:4326");
        Validators.validate(genericName);
        Assert.assertEquals((String)"Depth shall be counted from the \"urn\" namespace.", (long)5L, (long)genericName.depth());
        Assert.assertEquals((Object)"ogc:def:crs:epsg:4326", (Object)((Object)genericName).toString());
        Assert.assertEquals((Object)"urn:ogc:def:crs:epsg:4326", (Object)((Object)genericName.toFullyQualifiedName()).toString());
    }

    @Test
    public void testParsedHTTP() {
        Assume.assumeNotNull((Object[])new Object[]{this.factory});
        GenericName genericName = this.factory.createLocalName(null, "http");
        Assert.assertEquals((long)1L, (long)genericName.depth());
        Assert.assertEquals((Object)"http", (Object)((Object)genericName.head()).toString());
        Assert.assertEquals((Object)"http", (Object)((Object)genericName.tip()).toString());
        NameSpace nameSpace = this.createNameSpace(genericName, "://", ".");
        Validators.validate(nameSpace);
        genericName = this.factory.parseGenericName(nameSpace, "www.opengis.net");
        Assert.assertEquals((long)3L, (long)genericName.depth());
        Assert.assertEquals((Object)"www", (Object)((Object)genericName.head()).toString());
        Assert.assertEquals((Object)"net", (Object)((Object)genericName.tip()).toString());
        nameSpace = this.createNameSpace(genericName, "/", "/");
        Validators.validate(nameSpace);
        genericName = this.factory.parseGenericName(nameSpace, "gml/srs/epsg.xml");
        Assert.assertEquals((long)3L, (long)genericName.depth());
        Assert.assertEquals((Object)"gml", (Object)((Object)genericName.head()).toString());
        Assert.assertEquals((Object)"epsg.xml", (Object)((Object)genericName.tip()).toString());
        nameSpace = this.createNameSpace(genericName, "#", ":");
        Validators.validate(nameSpace);
        genericName = this.factory.createLocalName(nameSpace, "4326");
        Assert.assertEquals((long)1L, (long)genericName.depth());
        Assert.assertEquals((Object)"4326", (Object)((Object)genericName.head()).toString());
        Assert.assertEquals((Object)"4326", (Object)((Object)genericName.tip()).toString());
        Validators.validate(genericName);
        Assert.assertEquals((Object)"4326", (Object)((Object)genericName).toString());
        genericName = genericName.toFullyQualifiedName();
        Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/epsg.xml#4326", (Object)((Object)genericName).toString());
        Assert.assertEquals((long)8L, (long)genericName.depth());
        Assert.assertEquals((Object)"http", (Object)((Object)genericName.head()).toString());
        Assert.assertEquals((Object)"4326", (Object)((Object)genericName.tip()).toString());
    }
}

