/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.test.Assert;
import org.opengis.test.TestCase;
import org.opengis.test.referencing.SimpleDirectPosition;
import org.opengis.test.referencing.TransformFailure;

public strictfp abstract class TransformTestCase
extends TestCase {
    private static final int POINTS_OFFSET = 8;
    protected MathTransform transform;
    protected boolean isDoubleToDoubleSupported = true;
    protected boolean isFloatToFloatSupported = true;
    protected boolean isDoubleToFloatSupported = true;
    protected boolean isFloatToDoubleSupported = true;
    protected boolean isOverlappingArraySupported = true;
    protected boolean isInverseTransformSupported = true;
    protected double tolerance = 0.0;

    protected TransformTestCase() {
    }

    protected double tolerance(double d) {
        return this.tolerance;
    }

    protected void assertAllTestsEnabled() {
        Assert.assertTrue((String)"isDoubleToDoubleSupported", (boolean)this.isDoubleToDoubleSupported);
        Assert.assertTrue((String)"isFloatToFloatSupported", (boolean)this.isFloatToFloatSupported);
        Assert.assertTrue((String)"isDoubleToFloatSupported", (boolean)this.isDoubleToFloatSupported);
        Assert.assertTrue((String)"isFloatToDoubleSupported", (boolean)this.isFloatToDoubleSupported);
        Assert.assertTrue((String)"isOverlappingArraySupported", (boolean)this.isOverlappingArraySupported);
        Assert.assertTrue((String)"isInverseTransformSupported", (boolean)this.isInverseTransformSupported);
    }

    protected void verifyTransform(double[] dArray, double[] dArray2) throws TransformException {
        MathTransform mathTransform;
        MathTransform mathTransform2 = this.transform;
        Assert.assertNotNull((String)"TransformTestCase.transform shall be assigned a value.", (Object)mathTransform2);
        int n = mathTransform2.getSourceDimensions();
        int n2 = mathTransform2.getTargetDimensions();
        Assert.assertStrictlyPositive("Source dimension must be positive.", n);
        Assert.assertStrictlyPositive("Target dimension must be positive.", n2);
        if (this.isInverseTransformSupported) {
            mathTransform = mathTransform2.inverse();
            Assert.assertNotNull((String)"MathTransform.inverse() shall not return null.", (Object)mathTransform);
            Assert.assertEquals((String)"Inconsistent source dimension of the inverse transform.", (long)n2, (long)mathTransform.getSourceDimensions());
            Assert.assertEquals((String)"Inconsistent target dimension of the inverse transform.", (long)n, (long)mathTransform.getTargetDimensions());
        } else {
            mathTransform = null;
        }
        if (dArray2 == null) {
            Assert.assertNull((Object)dArray);
            return;
        }
        Assert.assertNotNull((Object)dArray);
        Assert.assertEquals((String)"Source dimension is not a divisor of the coordinates array length.", (long)0L, (long)(dArray.length % n));
        Assert.assertEquals((String)"Target dimension is not a divisor of the expected array length.", (long)0L, (long)(dArray2.length % n2));
        int n3 = dArray2.length / n2;
        Assert.assertEquals((String)"Mismatched number of points.", (long)n3, (long)(dArray.length / n));
        SimpleDirectPosition simpleDirectPosition = new SimpleDirectPosition(n);
        SimpleDirectPosition simpleDirectPosition2 = new SimpleDirectPosition(n2);
        SimpleDirectPosition simpleDirectPosition3 = new SimpleDirectPosition(n);
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            int n5 = i * n2;
            System.arraycopy(dArray, n4, simpleDirectPosition.ordinates, 0, n);
            Assert.assertSame((String)"MathTransform.transform(DirectPosition,...) shall use the given target.", (Object)simpleDirectPosition2, (Object)mathTransform2.transform(simpleDirectPosition, simpleDirectPosition2));
            this.assertCoordinatesEqual("Unexpected transform result.", n2, dArray2, n5, simpleDirectPosition2.ordinates, 0, 1, false, i);
            this.assertCoordinatesEqual("Source coordinate has been modified.", n, dArray, n4, simpleDirectPosition.ordinates, 0, 1, true, i);
            if (mathTransform == null) continue;
            System.arraycopy(dArray2, n5, simpleDirectPosition2.ordinates, 0, n2);
            Assert.assertSame((String)"MathTransform.transform(DirectPosition,...) shall use the given target.", (Object)simpleDirectPosition3, (Object)mathTransform.transform(simpleDirectPosition2, simpleDirectPosition3));
            this.assertCoordinateEquals("Unexpected result of inverse transform.", simpleDirectPosition.ordinates, simpleDirectPosition3.ordinates, i, false);
            this.assertCoordinatesEqual("Source coordinate has been modified.", n2, dArray2, n5, simpleDirectPosition2.ordinates, 0, 1, true, i);
        }
    }

    protected void verifyInverse(double[] dArray) throws TransformException {
        MathTransform mathTransform = this.transform;
        Assert.assertNotNull((String)"TransformTestCase.transform shall be assigned a value.", (Object)mathTransform);
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        Assert.assertStrictlyPositive("Source dimension must be positive.", n);
        Assert.assertStrictlyPositive("Target dimension must be positive.", n2);
        Assert.assertTrue((String)"isInverseTransformSupported == false.", (boolean)this.isInverseTransformSupported);
        MathTransform mathTransform2 = mathTransform.inverse();
        Assert.assertNotNull((String)"MathTransform.inverse() shall not return null.", (Object)mathTransform2);
        Assert.assertEquals((String)"Inconsistent source dimension of the inverse transform.", (long)n2, (long)mathTransform2.getSourceDimensions());
        Assert.assertEquals((String)"Inconsistent target dimension of the inverse transform.", (long)n, (long)mathTransform2.getTargetDimensions());
        Assert.assertNotNull((String)"Coordinates array expected in argument.", (Object)dArray);
        Assert.assertEquals((String)"Source dimension is not a divisor of the coordinates array length.", (long)0L, (long)(dArray.length % n));
        int n3 = dArray.length / n;
        SimpleDirectPosition simpleDirectPosition = new SimpleDirectPosition(n);
        SimpleDirectPosition simpleDirectPosition2 = new SimpleDirectPosition(n2);
        DirectPosition directPosition = null;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            System.arraycopy(dArray, n4, simpleDirectPosition.ordinates, 0, n);
            directPosition = mathTransform.transform(simpleDirectPosition, directPosition);
            Assert.assertNotNull((String)"MathTransform.transform(DirectPosition,...) shall not return null.", (Object)directPosition);
            Assert.assertEquals((String)"Transformed point has wrong dimension.", (long)n2, (long)directPosition.getDimension());
            Assert.assertSame((String)"MathTransform.transform(DirectPosition,...) shall use the given target.", (Object)simpleDirectPosition2, (Object)mathTransform2.transform(directPosition, simpleDirectPosition2));
            this.assertCoordinateEquals("Unexpected result of inverse transform.", simpleDirectPosition.ordinates, simpleDirectPosition2.ordinates, i, false);
            this.assertCoordinatesEqual("Source coordinate has been modified.", n, dArray, n4, simpleDirectPosition.ordinates, 0, 1, true, i);
        }
    }

    protected void verifyInverse(float[] fArray) throws TransformException {
        int n;
        double[] dArray = new double[fArray.length];
        for (n = 0; n < fArray.length; ++n) {
            dArray[n] = fArray[n];
        }
        this.verifyInverse(dArray);
        n = this.transform.getSourceDimensions();
        this.assertCoordinatesEqual("Unexpected change in source coordinates.", n, fArray, 0, dArray, 0, fArray.length / n, true);
    }

    protected float[] verifyConsistency(float[] fArray) throws TransformException {
        MathTransform mathTransform = this.transform;
        Assert.assertNotNull((String)"TransformTestCase.transform shall be assigned a value.", (Object)mathTransform);
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        Assert.assertEquals((String)"Source dimension is not a divisor of the coordinates array length.", (long)0L, (long)(fArray.length % n));
        int n3 = fArray.length / n;
        float[] fArray2 = new float[n2 * n3];
        float[] fArray3 = new float[Math.max(n, n2) * (n3 + 8)];
        double[] dArray = new double[fArray.length];
        double[] dArray2 = new double[fArray3.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = fArray[i];
        }
        SimpleDirectPosition simpleDirectPosition = new SimpleDirectPosition(n);
        DirectPosition directPosition = null;
        int n4 = 0;
        for (int i = 0; i < dArray.length; i += n) {
            System.arraycopy(dArray, i, simpleDirectPosition.ordinates, 0, n);
            directPosition = mathTransform.transform(simpleDirectPosition, directPosition);
            Assert.assertNotNull((String)"MathTransform.transform(DirectPosition,...) shall not return null.", (Object)directPosition);
            Assert.assertEquals((String)"MathTransform.transform(DirectPosition) must return a position having the same dimension than MathTransform.getTargetDimension().", (long)n2, (long)directPosition.getDimension());
            for (int j = 0; j < n2; ++j) {
                fArray2[n4++] = (float)directPosition.getOrdinate(j);
            }
        }
        Assert.assertEquals((long)fArray2.length, (long)n4);
        if (this.isDoubleToDoubleSupported) {
            Arrays.fill(dArray2, Double.NaN);
            mathTransform.transform(dArray, 0, dArray2, 0, n3);
            this.assertCoordinatesEqual("MathTransform.transform(double[],0,double[],0,n) modified a source coordinate.", n, fArray, 0, dArray, 0, n3, true);
            this.assertCoordinatesEqual("MathTransform.transform(double[],0,double[],0,n) error.", n2, dArray2, 0, fArray2, 0, n3, false);
        }
        if (this.isFloatToFloatSupported) {
            Arrays.fill(fArray3, Float.NaN);
            mathTransform.transform(fArray, 0, fArray3, 0, n3);
            this.assertCoordinatesEqual("MathTransform.transform(float[],0,float[],0,n) modified a source coordinate.", n, dArray, 0, fArray, 0, n3, true);
            this.assertCoordinatesEqual("MathTransform.transform(float[],0,float[],0,n) error.", n2, fArray2, 0, fArray3, 0, n3, false);
        }
        if (this.isDoubleToFloatSupported) {
            Arrays.fill(fArray3, Float.NaN);
            mathTransform.transform(dArray, 0, fArray3, 0, n3);
            this.assertCoordinatesEqual("MathTransform.transform(double[],0,float[],0,n) modified a source coordinate.", n, fArray, 0, dArray, 0, n3, true);
            this.assertCoordinatesEqual("MathTransform.transform(double[],0,float[],0,n) error.", n2, fArray2, 0, fArray3, 0, n3, false);
        }
        if (this.isFloatToDoubleSupported) {
            Arrays.fill(dArray2, Double.NaN);
            mathTransform.transform(fArray, 0, dArray2, 0, n3);
            this.assertCoordinatesEqual("MathTransform.transform(float[],0,double[],0,n) modified a source coordinate.", n, dArray, 0, fArray, 0, n3, true);
            this.assertCoordinatesEqual("MathTransform.transform(float[],0,double[],0,n) error.", n2, fArray2, 0, dArray2, 0, n3, false);
        }
        if (this.isOverlappingArraySupported) {
            for (int i = 0; i < 8 * n; i += n) {
                for (int j = 0; j < 8 * n2; j += n2) {
                    System.arraycopy(fArray, 0, fArray3, i, fArray.length);
                    System.arraycopy(dArray, 0, dArray2, i, dArray.length);
                    mathTransform.transform(fArray3, i, fArray3, j, n3);
                    mathTransform.transform(dArray2, i, dArray2, j, n3);
                    this.assertCoordinatesEqual("MathTransform.transform(float[],0,float[],0,n) error.", n2, fArray2, 0, fArray3, j, n3, false);
                    this.assertCoordinatesEqual("MathTransform.transform(double[],0,double[],0,n) error.", n2, fArray2, 0, dArray2, j, n3, false);
                }
            }
        }
        return fArray2;
    }

    protected final void assertCoordinateEquals(String string, float[] fArray, float[] fArray2, int n, boolean bl) {
        int n2 = fArray.length;
        Assert.assertEquals((long)n2, (long)fArray2.length);
        this.assertCoordinatesEqual(string, n2, fArray, 0, fArray2, 0, 1, bl, n);
    }

    protected final void assertCoordinateEquals(String string, float[] fArray, double[] dArray, int n, boolean bl) {
        int n2 = fArray.length;
        Assert.assertEquals((long)n2, (long)dArray.length);
        this.assertCoordinatesEqual(string, n2, fArray, 0, dArray, 0, 1, bl, n);
    }

    protected final void assertCoordinateEquals(String string, double[] dArray, float[] fArray, int n, boolean bl) {
        int n2 = dArray.length;
        Assert.assertEquals((long)n2, (long)fArray.length);
        this.assertCoordinatesEqual(string, n2, dArray, 0, fArray, 0, 1, bl, n);
    }

    protected final void assertCoordinateEquals(String string, double[] dArray, double[] dArray2, int n, boolean bl) {
        int n2 = dArray.length;
        Assert.assertEquals((long)n2, (long)dArray2.length);
        this.assertCoordinatesEqual(string, n2, dArray, 0, dArray2, 0, 1, bl, n);
    }

    protected final void assertCoordinatesEqual(String string, int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, boolean bl) {
        this.assertCoordinatesEqual(string, n, fArray, n2, fArray2, n3, n4, bl, 0);
    }

    protected final void assertCoordinatesEqual(String string, int n, float[] fArray, int n2, double[] dArray, int n3, int n4, boolean bl) {
        this.assertCoordinatesEqual(string, n, fArray, n2, dArray, n3, n4, bl, 0);
    }

    protected final void assertCoordinatesEqual(String string, int n, double[] dArray, int n2, float[] fArray, int n3, int n4, boolean bl) {
        this.assertCoordinatesEqual(string, n, dArray, n2, fArray, n3, n4, bl, 0);
    }

    protected final void assertCoordinatesEqual(String string, int n, double[] dArray, int n2, double[] dArray2, int n3, int n4, boolean bl) {
        this.assertCoordinatesEqual(string, n, dArray, n2, dArray2, n3, n4, bl, 0);
    }

    private void assertCoordinatesEqual(String string, int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, boolean bl, int n5) {
        int n6 = n4 * n;
        for (int i = 0; i < n6; ++i) {
            float f = fArray[n2++];
            float f2 = fArray2[n3++];
            if (!bl && Math.abs(f2 - f) <= (float)this.tolerance(f) || Float.floatToIntBits(f2) == Float.floatToIntBits(f)) continue;
            throw new TransformFailure(TransformTestCase.formatComparaisonFailure(string, n, fArray, n2, fArray2, n3, i, Float.valueOf(Math.abs(f2 - f)), n5));
        }
    }

    private void assertCoordinatesEqual(String string, int n, float[] fArray, int n2, double[] dArray, int n3, int n4, boolean bl, int n5) {
        int n6 = n4 * n;
        for (int i = 0; i < n6; ++i) {
            float f = fArray[n2++];
            float f2 = (float)dArray[n3++];
            if (!bl && Math.abs(f2 - f) <= (float)this.tolerance(f) || Float.floatToIntBits(f2) == Float.floatToIntBits(f)) continue;
            throw new TransformFailure(TransformTestCase.formatComparaisonFailure(string, n, fArray, n2, dArray, n3, i, Float.valueOf(Math.abs(f2 - f)), n5));
        }
    }

    private void assertCoordinatesEqual(String string, int n, double[] dArray, int n2, float[] fArray, int n3, int n4, boolean bl, int n5) {
        int n6 = n4 * n;
        for (int i = 0; i < n6; ++i) {
            float f = (float)dArray[n2++];
            float f2 = fArray[n3++];
            if (!bl && Math.abs(f2 - f) <= (float)this.tolerance(f) || Float.floatToIntBits(f2) == Float.floatToIntBits(f)) continue;
            throw new TransformFailure(TransformTestCase.formatComparaisonFailure(string, n, dArray, n2, fArray, n3, i, Float.valueOf(Math.abs(f2 - f)), n5));
        }
    }

    private void assertCoordinatesEqual(String string, int n, double[] dArray, int n2, double[] dArray2, int n3, int n4, boolean bl, int n5) {
        int n6 = n4 * n;
        for (int i = 0; i < n6; ++i) {
            double d = dArray[n2++];
            double d2 = dArray2[n3++];
            if (!bl && Math.abs(d2 - d) <= this.tolerance(d) || Double.doubleToLongBits(d2) == Double.doubleToLongBits(d)) continue;
            throw new TransformFailure(TransformTestCase.formatComparaisonFailure(string, n, dArray, n2, dArray2, n3, i, Math.abs(d2 - d), n5));
        }
    }

    private static String formatComparaisonFailure(String string, int n, Object object, int n2, Object object2, int n3, int n4, Number number, int n5) {
        int n6;
        int n7 = n4 % n;
        n2 -= n7 + 1;
        n3 -= n7 + 1;
        String string2 = System.getProperty("line.separator", "\n");
        StringBuilder stringBuilder = new StringBuilder(string).append(string2).append("DirectPosition").append(n).append("D[").append(n4 / n + n5).append("]: Expected (");
        for (n6 = 0; n6 < n; ++n6) {
            if (n6 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Array.get(object, n2++));
        }
        stringBuilder.append(") but got (");
        for (n6 = 0; n6 < n; ++n6) {
            if (n6 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Array.get(object2, n3++));
        }
        return stringBuilder.append(").").append(string2).append("The delta at ordinate ").append(n7).append(" is ").append(number).toString();
    }
}

