/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.OffsetOrdinateFilter;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.WrappingCoordinateFilter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WrappingProjectionHandler
extends ProjectionHandler {
    protected double radius;

    public WrappingProjectionHandler(ReferencedEnvelope renderingEnvelope, ReferencedEnvelope validArea, double centralMeridian) {
        super(renderingEnvelope, validArea);
        try {
            CoordinateReferenceSystem targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            double[] src = new double[]{centralMeridian, 0.0, 180.0 + centralMeridian, 0.0};
            double[] dst = new double[4];
            mt.transform(src, 0, dst, 0, 2);
            this.radius = CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST ? Math.abs(dst[3] - dst[1]) : Math.abs(dst[2] - dst[0]);
            if (this.radius <= 0.0) {
                throw new RuntimeException("Computed Earth radius is 0, what is going on?");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error computing the Earth radius in the current projection", e);
        }
    }

    @Override
    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        Envelope env = geometry.getEnvelopeInternal();
        if (env.getWidth() < this.radius && this.renderingEnvelope.contains(env) && this.renderingEnvelope.getWidth() <= this.radius * 2.0) {
            return geometry;
        }
        if (env.getWidth() > this.radius && env.getWidth() < this.radius * 2.0) {
            geometry.apply((GeometryComponentFilter)new WrappingCoordinateFilter(this.radius, this.radius * 2.0, mt));
            geometry.geometryChanged();
            env = geometry.getEnvelopeInternal();
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        Class geomType = null;
        double min = env.getMinX();
        double max = env.getMaxX();
        while (min > this.renderingEnvelope.getMinX()) {
            min -= this.radius * 2.0;
            max -= this.radius * 2.0;
        }
        while (max < this.renderingEnvelope.getMinX()) {
            min += this.radius * 2.0;
            max += this.radius * 2.0;
        }
        geomType = this.accumulate(geoms, geometry, geomType);
        while (min <= this.renderingEnvelope.getMaxX()) {
            double offset = min - env.getMinX();
            if (!(Math.abs(offset) < this.radius)) {
                Geometry offseted = (Geometry)geometry.clone();
                offseted.apply((CoordinateSequenceFilter)new OffsetOrdinateFilter(0, offset));
                offseted.geometryChanged();
                geomType = this.accumulate(geoms, offseted, geomType);
            }
            min += this.radius * 2.0;
        }
        if (geomType == null) {
            return null;
        }
        if (geoms.size() == 1) {
            return (Geometry)geoms.get(0);
        }
        if (Point.class.equals((Object)geomType)) {
            Point[] points = geoms.toArray(new Point[geoms.size()]);
            return geometry.getFactory().createMultiPoint(points);
        }
        if (LineString.class.isAssignableFrom(geomType)) {
            LineString[] lines = geoms.toArray(new LineString[geoms.size()]);
            return geometry.getFactory().createMultiLineString(lines);
        }
        if (Polygon.class.equals((Object)geomType)) {
            Polygon[] polys = geoms.toArray(new Polygon[geoms.size()]);
            return geometry.getFactory().createMultiPolygon(polys);
        }
        return geometry.getFactory().createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
    }

    private Class accumulate(List<Geometry> geoms, Geometry geometry, Class geomType) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry g = geometry.getGeometryN(i);
            Class<?> gtype = null;
            if (g instanceof GeometryCollection) {
                gtype = this.accumulate(geoms, g, geomType);
            } else if (this.renderingEnvelope.intersects(g.getEnvelopeInternal())) {
                geoms.add(g);
                gtype = g.getClass();
            }
            if (geomType == null) {
                geomType = g.getClass();
                continue;
            }
            if (g.getClass().equals(geomType)) continue;
            geomType = Geometry.class;
        }
        return geomType;
    }

    @Override
    public boolean requiresProcessing(CoordinateReferenceSystem geomCRS, Geometry geometry) {
        return true;
    }
}

