/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.util.logging.Logging;
import org.geotools.xml.BindingFactory;
import org.geotools.xml.Configuration;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.ParserDelegate;
import org.geotools.xml.ParserDelegate2;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.BindingWalker;
import org.geotools.xml.impl.BindingWalkerFactoryImpl;
import org.geotools.xml.impl.DelegatingHandler;
import org.geotools.xml.impl.DocumentHandler;
import org.geotools.xml.impl.ElementHandler;
import org.geotools.xml.impl.Handler;
import org.geotools.xml.impl.HandlerFactory;
import org.geotools.xml.impl.HandlerFactoryImpl;
import org.geotools.xml.impl.NamespaceSupportWrapper;
import org.geotools.xml.impl.SchemaIndexImpl;
import org.geotools.xml.impl.ValidatorHandler;
import org.geotools.xs.XS;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ParserHandler
extends DefaultHandler {
    protected Stack handlers;
    NamespaceSupport namespaces;
    XSDSchema[] schemas;
    SchemaIndex index;
    HandlerFactory handlerFactory;
    BindingLoader bindingLoader;
    BindingWalker bindingWalker;
    BindingFactory bindingFactory;
    DocumentHandler documentHandler;
    Configuration config;
    MutablePicoContainer context;
    Logger logger;
    boolean validating;
    ValidatorHandler validator;
    boolean strict = false;
    boolean handleMixedContent = false;
    boolean forceParserDelegate = false;
    QName rootElementType = null;

    public ParserHandler(Configuration config) {
        this.config = config;
        this.namespaces = new NamespaceSupport();
        this.validating = false;
        this.validator = new ValidatorHandler();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.validator.setFailOnValidationError(failOnValidationError);
    }

    public boolean isFailOnValidationError() {
        return this.validator.isFailOnValidationError();
    }

    public void setHandleMixedContent(boolean handleMixedContent) {
        this.handleMixedContent = handleMixedContent;
    }

    public boolean isHandleMixedContent() {
        return this.handleMixedContent;
    }

    public void setForceParserDelegate(boolean forceParserDelegate) {
        this.forceParserDelegate = forceParserDelegate;
    }

    public boolean isForceParserDelegate() {
        return this.forceParserDelegate;
    }

    public void setRootElementType(QName rootElementType) {
        this.rootElementType = rootElementType;
    }

    public QName getRootElementType() {
        return this.rootElementType;
    }

    public List getValidationErrors() {
        return this.validator.getErrors();
    }

    public ValidatorHandler getValidator() {
        return this.validator;
    }

    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public BindingLoader getBindingLoader() {
        return this.bindingLoader;
    }

    public BindingWalker getBindingWalker() {
        return this.bindingWalker;
    }

    public BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public XSDSchema[] getSchemas() {
        return this.schemas;
    }

    public SchemaIndex getSchemaIndex() {
        return this.index;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.namespaces;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.declarePrefix(prefix, uri);
    }

    @Override
    public void startDocument() throws SAXException {
        this.configure(this.config);
        DocumentHandler docHandler = this.handlerFactory.createDocumentHandler(this);
        this.context = new DefaultPicoContainer();
        this.context = this.config.setupContext(this.context);
        docHandler.setContext(this.context);
        this.handlers = new Stack();
        this.handlers.push(docHandler);
        this.logger = (Logger)this.context.getComponentInstanceOfType(Logger.class);
        if (this.logger == null) {
            this.logger = Logging.getLogger((String)"org.geotools.xml");
            this.context.registerComponentInstance((Object)this.logger);
        }
        this.context.registerComponentInstance((Object)this.namespaces);
        this.context.registerComponentInstance((Object)new NamespaceSupportWrapper(this.namespaces));
        this.bindingFactory = new BindingFactoryImpl(this.bindingLoader);
        this.context.registerComponentInstance((Object)this.bindingFactory);
        this.context.registerComponentInstance((Object)new BindingWalkerFactoryImpl(this.bindingLoader, this.context));
        this.context.registerComponentInstance((Object)this.config);
        this.validator.startDocument();
        docHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        XSDElementDeclaration element;
        String prefix;
        boolean root;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("startElement(" + uri + "," + localName + "," + qName);
        }
        boolean bl = root = this.schemas == null;
        if (root) {
            int i;
            String[] locations = null;
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String name = attributes.getQName(i2);
                if (!name.endsWith("schemaLocation")) continue;
                this.logger.finer("schemaLocation found: " + attributes.getValue(i2));
                locations = attributes.getValue(i2).split(" +");
                break;
            }
            if (!this.isStrict() && locations == null) {
                this.logger.finer("No schemaLocation found, using '" + this.config.getNamespaceURI() + " " + this.config.getSchemaFileURL());
                locations = new String[]{this.config.getNamespaceURI(), this.config.getSchemaFileURL()};
            }
            XSDSchemaLocator[] locators = this.findSchemaLocators();
            XSDSchemaLocationResolver[] resolvers = this.findSchemaLocationResolvers();
            if (locations != null && locations.length > 0) {
                this.schemas = new XSDSchema[locations.length / 2];
                for (i = 0; i < locations.length; i += 2) {
                    int j;
                    String namespace = locations[i];
                    String location = null;
                    if (i + 1 >= locations.length) {
                        this.logger.warning("Schema location not specified as namespace/location pair. Ignoring " + namespace);
                        continue;
                    }
                    location = locations[i + 1];
                    for (j = 0; j < resolvers.length; ++j) {
                        String override = resolvers[j].resolveSchemaLocation(null, namespace, location);
                        if (override == null) continue;
                        override = override.replaceAll(" ", "%20");
                        this.logger.finer("Found override for " + namespace + ": " + location + " ==> " + override);
                        location = override;
                        break;
                    }
                    for (j = 0; j < locators.length; ++j) {
                        XSDSchema schema = locators[j].locateSchema(null, namespace, location, null);
                        if (schema == null) continue;
                        this.schemas[i / 2] = schema;
                        break;
                    }
                    if (this.schemas[i / 2] != null) continue;
                    if (this.isValidating()) {
                        try {
                            Schemas.validateImportsIncludes(location, locators, resolvers);
                        }
                        catch (IOException e) {
                            throw (SAXException)new SAXException("error validating").initCause(e);
                        }
                    }
                    try {
                        this.schemas[i / 2] = Schemas.parse(location, locators, resolvers);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = "Error parsing: " + location;
                        this.logger.warning(msg);
                        if (!this.isStrict()) continue;
                        throw (SAXException)new SAXException(msg).initCause(e);
                    }
                }
            } else {
                for (i = 0; i < locators.length; ++i) {
                    XSDSchema schema = locators[i].locateSchema(null, uri, null, null);
                    if (schema == null) continue;
                    this.schemas = new XSDSchema[]{schema};
                    break;
                }
            }
            int n = 0;
            for (int i3 = 0; i3 < this.schemas.length; ++i3) {
                if (this.schemas[i3] == null) continue;
                ++n;
            }
            if (n != this.schemas.length) {
                XSDSchema[] nschemas = new XSDSchema[n];
                int j = 0;
                for (int i4 = 0; i4 < this.schemas.length; ++i4) {
                    if (this.schemas[i4] == null) continue;
                    nschemas[j++] = this.schemas[i4];
                }
                this.schemas = nschemas;
            }
            if (this.schemas == null || this.schemas.length == 0) {
                this.logger.warning("Could not find a schema");
                if (this.isStrict()) {
                    String msg = "Could not find a schemaLocation attribute or appropriate locator";
                    throw new SAXException(msg);
                }
                try {
                    this.schemas = new XSDSchema[]{this.config.getXSD().getSchema()};
                }
                catch (IOException e) {
                    throw (SAXException)new SAXException().initCause(e);
                }
            }
            boolean found = false;
            block13: for (int i5 = 0; i5 < this.schemas.length; ++i5) {
                if (this.config.getNamespaceURI().equals(this.schemas[i5].getTargetNamespace())) {
                    found = true;
                    break;
                }
                List imports = Schemas.getImports(this.schemas[i5]);
                for (XSDImport imprt : imports) {
                    if (!this.config.getNamespaceURI().equals(imprt.getNamespace())) continue;
                    found = true;
                    break block13;
                }
            }
            if (!found) {
                if (!this.isStrict()) {
                    this.logger.fine("schema specified by parser configuration not found, supplementing...");
                    XSDSchema[] copy = new XSDSchema[this.schemas.length + 1];
                    System.arraycopy(this.schemas, 0, copy, 0, this.schemas.length);
                    copy[this.schemas.length] = this.config.schema();
                    this.schemas = copy;
                } else {
                    String msg = "parser configuration specified schema: '" + this.config.getNamespaceURI() + "', but instance document does not reference this schema.";
                    this.logger.info(msg);
                }
            }
            this.index = new SchemaIndexImpl(this.schemas);
            this.context.registerComponentInstance((Object)this.index);
            if (this.namespaces.getURI("") == null) {
                this.namespaces.declarePrefix("", this.config.getNamespaceURI());
            }
        }
        this.namespaces.pushContext();
        if (uri == null || uri.equals("")) {
            uri = this.namespaces.getURI("");
        }
        QName qualifiedName = (prefix = this.namespaces.getPrefix(uri)) != null ? new QName(uri, localName, prefix) : new QName(uri, localName);
        Handler parent = (Handler)this.handlers.peek();
        ElementHandler handler = (ElementHandler)parent.createChildHandler(qualifiedName);
        if (handler == null && (element = this.index.getElementDeclaration(qualifiedName)) != null) {
            handler = this.handlerFactory.createElementHandler(element, parent, this);
        }
        if (handler == null) {
            List handlerFactories = this.context.getComponentInstancesOfType(HandlerFactory.class);
            Iterator hf = handlerFactories.iterator();
            while (handler == null && hf.hasNext()) {
                HandlerFactory handlerFactory = (HandlerFactory)hf.next();
                handler = handlerFactory.createElementHandler(qualifiedName, parent, this);
            }
        }
        if (handler == null || this.forceParserDelegate) {
            List<ComponentAdapter> adapters = Schemas.getComponentAdaptersOfType((PicoContainer)this.context, ParserDelegate.class);
            for (ComponentAdapter adapter : adapters) {
                ParserDelegate delegate = (ParserDelegate)adapter.getComponentInstance((PicoContainer)this.context);
                boolean canHandle = delegate instanceof ParserDelegate2 ? ((ParserDelegate2)((Object)delegate)).canHandle(qualifiedName, attributes, handler, parent) : delegate.canHandle(qualifiedName);
                if (!canHandle) continue;
                handler = new DelegatingHandler(delegate, qualifiedName, parent);
                ((DelegatingHandler)handler).startDocument();
            }
        }
        if (handler == null && !this.isStrict()) {
            ElementInstance parentElement;
            List childParticles;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Could not find declaration for: " + qualifiedName + ". Checking if containing type declares a single particle.");
            }
            if (parent.getComponent() instanceof ElementInstance && (childParticles = this.index.getChildElementParticles((parentElement = (ElementInstance)parent.getComponent()).getElementDeclaration())).size() == 1) {
                XSDParticle particle = (XSDParticle)childParticles.iterator().next();
                XSDElementDeclaration child = (XSDElementDeclaration)particle.getContent();
                if (child.isElementDeclarationReference()) {
                    child = child.getResolvedElementDeclaration();
                }
                handler = this.handlerFactory.createElementHandler(new QName(child.getTargetNamespace(), child.getName()), parent, this);
            }
        }
        if (handler == null && !this.isStrict()) {
            String msg = "Could not find declaration for: " + qualifiedName + ". Performing lookup by ignoring namespace";
            this.logger.fine(msg);
            handler = (ElementHandler)parent.createChildHandler(new QName("*", qualifiedName.getLocalPart()));
        }
        if (handler == null && !this.isStrict()) {
            XSDTypeDefinition type;
            String msg = "Could not find declaration for: " + qualifiedName + ". Creating a mock element declaration and parsing anyways...";
            this.logger.fine(msg);
            XSDElementDeclaration decl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            decl.setName(qualifiedName.getLocalPart());
            decl.setTargetNamespace(qualifiedName.getNamespaceURI());
            QName typeDefinition = null;
            if (root && this.rootElementType != null) {
                typeDefinition = this.rootElementType;
            }
            if (typeDefinition == null && (typeDefinition = (QName)this.context.getComponentInstance((Object)"http://geotools.org/typeDefinition")) != null) {
                this.context.unregisterComponent((Object)"http://geotools.org/typeDefinition");
            }
            if (typeDefinition != null) {
                type = this.index.getTypeDefinition(typeDefinition);
                if (type == null) {
                    throw new NullPointerException();
                }
                decl.setTypeDefinition(type);
            } else {
                type = this.index.getTypeDefinition(XS.ANYTYPE);
                decl.setTypeDefinition(type);
            }
            handler = this.handlerFactory.createElementHandler(decl, parent, this);
        }
        if (handler != null) {
            if (handler.getElementDeclaration().getTargetNamespace() != null && !handler.getElementDeclaration().getTargetNamespace().equals(uri) && !handler.getElementDeclaration().isAbstract()) {
                this.namespaces.declarePrefix("", handler.getElementDeclaration().getTargetNamespace());
                qualifiedName = new QName(handler.getElementDeclaration().getTargetNamespace(), qualifiedName.getLocalPart());
            }
        } else {
            String msg = "Handler for " + qName + " could not be found.";
            throw new SAXException(msg);
        }
        handler.startElement(qualifiedName, attributes);
        this.handlers.push(handler);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.peek();
        handler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementHandler handler = (ElementHandler)this.handlers.pop();
        String prefix = this.namespaces.getPrefix(uri);
        QName qualifiedName = prefix != null ? new QName(uri, localName, prefix) : new QName(uri, localName);
        handler.endElement(qualifiedName);
        this.endElementInternal(handler);
        if (handler instanceof DelegatingHandler && !this.handlers.isEmpty() && !(this.handlers.peek() instanceof DelegatingHandler)) {
            DelegatingHandler dh = (DelegatingHandler)handler;
            dh.endDocument();
            dh.getParseNode().setValue(dh.delegate.getParsedObject());
        }
        this.namespaces.popContext();
    }

    protected void endElementInternal(ElementHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDocument() throws SAXException {
        this.validator.endDocument();
        this.documentHandler = (DocumentHandler)this.handlers.pop();
        this.documentHandler.endDocument();
        if (this.index != null) {
            this.index.destroy();
        }
        this.index = null;
        this.schemas = null;
        ParserHandler parserHandler = this;
        synchronized (parserHandler) {
            this.notifyAll();
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.isValidating()) {
            this.validator.warning(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.logger.log(Level.WARNING, e.getMessage());
        if (this.isValidating()) {
            this.validator.error(e);
        }
    }

    public Object getValue() {
        return this.documentHandler.getParseNode().getValue();
    }

    protected void configure(Configuration config) {
        Map bindings = config.setupBindings();
        this.handlerFactory = new HandlerFactoryImpl();
        this.bindingLoader = new BindingLoader(bindings);
        this.bindingWalker = new BindingWalker(this.bindingLoader);
    }

    protected XSDSchemaLocator[] findSchemaLocators() {
        List l = Schemas.getComponentInstancesOfType((PicoContainer)this.context, XSDSchemaLocator.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocator[0];
        }
        return l.toArray(new XSDSchemaLocator[l.size()]);
    }

    protected XSDSchemaLocationResolver[] findSchemaLocationResolvers() {
        List l = Schemas.getComponentInstancesOfType((PicoContainer)this.context, XSDSchemaLocationResolver.class);
        if (l == null || l.isEmpty()) {
            return new XSDSchemaLocationResolver[0];
        }
        return l.toArray(new XSDSchemaLocationResolver[l.size()]);
    }
}

