/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.util.logging.Logging;
import org.geotools.xml.XSD;

public class SchemaLocator
implements XSDSchemaLocator {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geotools.xml");
    protected XSD xsd;

    public SchemaLocator(XSD xsd) {
        this.xsd = xsd;
    }

    public boolean canHandle(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
        return this.xsd.getNamespaceURI().equals(namespaceURI);
    }

    public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
        if (this.canHandle(schema, namespaceURI, rawSchemaLocationURI, resolvedSchemaLocationURI)) {
            try {
                return this.xsd.getSchema();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error occured getting schema", e);
            }
        }
        return null;
    }

    public String toString() {
        return this.xsd.toString();
    }
}

