/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryTypeConverterFactory
implements ConverterFactory {
    private static final Logger LOGGER = Logging.getLogger(GeometryTypeConverterFactory.class);
    static GeometryFactory gFac = new GeometryFactory();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Geometry.class.isAssignableFrom(source) && Geometry.class.isAssignableFrom(target)) {
            return new Converter(){

                public <T> List<T> convertAll(GeometryCollection gc, Class<T> target) throws Exception {
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (int count = 0; count < gc.getNumGeometries(); ++count) {
                        Object geo = this.convert((Object)gc.getGeometryN(count), (Class)target);
                        if (geo == null) continue;
                        result.add(geo);
                    }
                    return result;
                }

                public Object convert(Object source, Class target) throws Exception {
                    if (target.isAssignableFrom(source.getClass())) {
                        return source;
                    }
                    if (source instanceof Geometry) {
                        Geometry sourceGeometry = (Geometry)source;
                        MultiPoint destGeometry = null;
                        if (MultiPoint.class.isAssignableFrom(target)) {
                            Point[] points = sourceGeometry.isEmpty() ? new Point[]{} : (source instanceof Point ? new Point[]{(Point)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Point.class).toArray(new Point[0]) : new Point[]{(Point)this.convert(source, Point.class)}));
                            destGeometry = gFac.createMultiPoint(points);
                        } else if (MultiLineString.class.isAssignableFrom(target)) {
                            LineString[] lineStrings = sourceGeometry.isEmpty() ? new LineString[]{} : (source instanceof LineString ? new LineString[]{(LineString)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, LineString.class).toArray(new LineString[0]) : new LineString[]{(LineString)this.convert(source, LineString.class)}));
                            destGeometry = gFac.createMultiLineString(lineStrings);
                        } else if (MultiPolygon.class.isAssignableFrom(target)) {
                            Polygon[] polygons = sourceGeometry.isEmpty() ? new Polygon[]{} : (source instanceof Polygon ? new Polygon[]{(Polygon)source} : (source instanceof GeometryCollection ? this.convertAll((GeometryCollection)source, Polygon.class).toArray(new Polygon[0]) : new Polygon[]{(Polygon)this.convert(source, Polygon.class)}));
                            destGeometry = gFac.createMultiPolygon(polygons);
                        } else if (GeometryCollection.class.isAssignableFrom(target)) {
                            destGeometry = sourceGeometry.isEmpty() ? gFac.createGeometryCollection(new Geometry[0]) : gFac.createGeometryCollection(new Geometry[]{(Geometry)source});
                        } else if (Point.class.isAssignableFrom(target)) {
                            if (sourceGeometry.isEmpty()) {
                                destGeometry = gFac.createPoint((Coordinate)null);
                            } else if (source instanceof MultiPoint && sourceGeometry.getNumGeometries() == 1) {
                                destGeometry = (Geometry)((MultiPoint)source).getGeometryN(0).clone();
                            } else {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Converting Geometry " + source.toString() + " to Point. This could be unsafe");
                                }
                                destGeometry = ((Geometry)source).getCentroid();
                            }
                        } else if (LineString.class.isAssignableFrom(target)) {
                            if (sourceGeometry.isEmpty()) {
                                destGeometry = gFac.createLineString(new Coordinate[0]);
                            } else if (source instanceof MultiLineString && sourceGeometry.getNumGeometries() == 1) {
                                destGeometry = (Geometry)((MultiLineString)source).getGeometryN(0).clone();
                            } else {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Converting Geometry " + source.toString() + " to LineString. This could be unsafe");
                                }
                                destGeometry = gFac.createLineString(this.getLineStringCoordinates(((Geometry)source).getCoordinates()));
                            }
                        } else if (Polygon.class.isAssignableFrom(target)) {
                            if (sourceGeometry.isEmpty()) {
                                destGeometry = gFac.createLineString(new Coordinate[0]);
                            } else if (source instanceof MultiPolygon && sourceGeometry.getNumGeometries() == 1) {
                                destGeometry = (Geometry)((MultiPolygon)source).getGeometryN(0).clone();
                            } else {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Converting Geometry " + source.toString() + " to Polygon. This could be unsafe");
                                }
                                Coordinate[] coords = this.getPolygonCoordinates(((Geometry)source).getCoordinates());
                                destGeometry = gFac.createPolygon(gFac.createLinearRing(coords), new LinearRing[0]);
                            }
                        }
                        if (destGeometry != null) {
                            HashMap<Class<CoordinateReferenceSystem>, Object> newUserData = new HashMap<Class<CoordinateReferenceSystem>, Object>();
                            if (destGeometry.getUserData() instanceof Map) {
                                newUserData.putAll((Map)destGeometry.getUserData());
                            } else if (destGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                                newUserData.put(CoordinateReferenceSystem.class, destGeometry.getUserData());
                            }
                            if (sourceGeometry.getUserData() instanceof Map) {
                                newUserData.putAll((Map)sourceGeometry.getUserData());
                            } else if (sourceGeometry.getUserData() instanceof CoordinateReferenceSystem) {
                                newUserData.put(CoordinateReferenceSystem.class, sourceGeometry.getUserData());
                            }
                            destGeometry.setUserData(newUserData);
                        }
                        return destGeometry;
                    }
                    return null;
                }

                private <T> T[] arrayCopy(T[] original, int length) {
                    Class<?> arrayType = original.getClass().getComponentType();
                    Object[] copy = (Object[])Array.newInstance(arrayType, length);
                    System.arraycopy(original, 0, copy, 0, original.length < length ? original.length : length);
                    return copy;
                }

                private Coordinate[] growCoordinatesNum(Coordinate[] input, int numpoints) {
                    if (input.length < numpoints) {
                        Object[] newCoordinates = this.arrayCopy(input, numpoints);
                        Arrays.fill(newCoordinates, input.length, numpoints, input[0]);
                        input = newCoordinates;
                    }
                    return input;
                }

                private Coordinate[] getLineStringCoordinates(Coordinate[] coordinates) {
                    coordinates = this.growCoordinatesNum(coordinates, 2);
                    return coordinates;
                }

                private Coordinate[] getPolygonCoordinates(Coordinate[] coordinates) {
                    if (!(coordinates = this.growCoordinatesNum(coordinates, 4))[coordinates.length - 1].equals((Object)coordinates[0])) {
                        Coordinate[] newCoordinates = this.arrayCopy(coordinates, coordinates.length + 1);
                        newCoordinates[newCoordinates.length - 1] = newCoordinates[0];
                        coordinates = newCoordinates;
                    }
                    return coordinates;
                }
            };
        }
        return null;
    }
}

