/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import org.geotools.filter.GeometryFilterImpl;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public abstract class AbstractPreparedGeometryFilter
extends GeometryFilterImpl {
    private final PreparedGeometryFactory pGeomFac = new PreparedGeometryFactory();
    protected Literals literals;
    protected PreparedGeometry leftPreppedGeom;
    protected PreparedGeometry rightPreppedGeom;
    protected boolean cacheValue;

    protected AbstractPreparedGeometryFilter(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    protected AbstractPreparedGeometryFilter(FilterFactory factory, Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(factory, e1, e2, matchAction);
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    private void prepare() {
        if (this.expression1 == null || this.expression2 == null) {
            return;
        }
        this.literals = Literals.calculate(this.expression1, this.expression2);
        switch (this.literals) {
            case BOTH: {
                Geometry left = (Geometry)((Literal)this.expression1).getValue();
                Geometry right = (Geometry)((Literal)this.expression2).getValue();
                this.cacheValue = this.basicEvaluate(left, right);
                this.rightPreppedGeom = null;
                this.leftPreppedGeom = null;
                break;
            }
            case LEFT: {
                Geometry left = (Geometry)((Literal)this.expression1).getValue();
                this.leftPreppedGeom = this.pGeomFac.create(left);
                this.rightPreppedGeom = null;
                this.cacheValue = false;
                break;
            }
            case RIGHT: {
                Geometry right = (Geometry)((Literal)this.expression2).getValue();
                this.rightPreppedGeom = this.pGeomFac.create(right);
                this.leftPreppedGeom = null;
                this.cacheValue = false;
                break;
            }
            default: {
                this.rightPreppedGeom = null;
                this.leftPreppedGeom = null;
                this.cacheValue = false;
            }
        }
    }

    @Override
    public void setExpression1(Expression expression) {
        super.setExpression1(expression);
        this.prepare();
    }

    @Override
    public void setExpression2(Expression expression) {
        super.setExpression2(expression);
        this.prepare();
    }

    protected abstract boolean basicEvaluate(Geometry var1, Geometry var2);

    protected static enum Literals {
        NEITHER,
        RIGHT,
        LEFT,
        BOTH;


        private static Literals calculate(Expression expression1, Expression expression2) {
            boolean right;
            boolean left = expression1 instanceof Literal && ((Literal)expression1).getValue() instanceof Geometry;
            boolean bl = right = expression2 instanceof Literal && ((Literal)expression2).getValue() instanceof Geometry;
            if (left && right) {
                return BOTH;
            }
            if (left) {
                return LEFT;
            }
            if (right) {
                return RIGHT;
            }
            return NEITHER;
        }
    }
}

