/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.geotools.data.Base64;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;

public class SimpleHttpClient
implements HTTPClient {
    private static final int DEFAULT_TIMEOUT = 30000;
    private String user;
    private String password;
    private int connectTimeout = 30000;
    private int readTimeout = 30000;

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setRequestMethod("GET");
        connection.connect();
        return new SimpleHTTPResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        if (postContentType != null) {
            connection.setRequestProperty("Content-type", postContentType);
        }
        connection.connect();
        OutputStream outputStream = connection.getOutputStream();
        try {
            int count;
            byte[] buff = new byte[512];
            while ((count = postContent.read(buff)) > -1) {
                outputStream.write(buff, 0, count);
            }
        }
        finally {
            outputStream.flush();
            outputStream.close();
        }
        return new SimpleHTTPResponse(connection);
    }

    private HttpURLConnection openConnection(URL finalURL) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)finalURL.openConnection();
        connection.addRequestProperty("Accept-Encoding", "gzip");
        connection.setConnectTimeout(this.getConnectTimeout());
        connection.setReadTimeout(this.getReadTimeout());
        String username = this.getUser();
        String password = this.getPassword();
        if (username != null && password != null) {
            String userpassword = username + ":" + password;
            String encodedAuthorization = Base64.encodeBytes(userpassword.getBytes("UTF-8"));
            connection.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
        }
        return connection;
    }

    public static class SimpleHTTPResponse
    implements HTTPResponse {
        private HttpURLConnection connection;
        private InputStream responseStream;

        public SimpleHTTPResponse(HttpURLConnection connection) {
            this.connection = connection;
        }

        @Override
        public void dispose() {
            if (this.responseStream != null) {
                try {
                    this.responseStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.responseStream = null;
            }
            if (this.connection != null) {
                this.connection.disconnect();
                this.connection = null;
            }
        }

        @Override
        public String getContentType() {
            return this.connection.getContentType();
        }

        @Override
        public String getResponseHeader(String headerName) {
            return this.connection.getHeaderField(headerName);
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            if (this.responseStream == null) {
                InputStream inputStream = this.connection.getInputStream();
                String contentEncoding = this.connection.getContentEncoding();
                if (contentEncoding != null && this.connection.getContentEncoding().indexOf("gzip") != -1) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                this.responseStream = inputStream;
            }
            return this.responseStream;
        }
    }
}

