/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.GeometryFactory;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionTypeBinding
extends AbstractComplexBinding {
    GeometryFactory factory;

    public DirectPositionTypeBinding(GeometryFactory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return GML.DirectPositionType;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return DirectPosition2D.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] position = (Double[])value;
        DirectPosition dp = null;
        if (position.length < 2) {
            dp = crs != null ? new DirectPosition1D(crs) : new DirectPosition1D();
            dp.setOrdinate(0, position[0]);
        } else {
            dp = crs != null ? new DirectPosition2D(crs) : new DirectPosition2D();
            dp.setOrdinate(0, position[0]);
            dp.setOrdinate(1, position[1]);
        }
        return dp;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        DirectPosition dp = (DirectPosition)object;
        double[] coordinates = dp.getCoordinate();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coordinates.length; ++i) {
            sb.append(String.valueOf(coordinates[i]));
            if (i == coordinates.length - 1) continue;
            sb.append(" ");
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }
}

