/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.Collections;
import java.util.Map;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

public class Parameter<T>
implements org.opengis.parameter.Parameter<T> {
    public final String key;
    public final InternationalString title;
    public final InternationalString description;
    public final Class<T> type;
    public final boolean required;
    public final int minOccurs;
    public final int maxOccurs;
    public final Object sample;
    public static final String FEATURE_TYPE = "featureType";
    public static final String IS_PASSWORD = "isPassword";
    public static final String LENGTH = "length";
    public static final String CRS = "crs";
    public static final String ELEMENT = "element";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String OPTIONS = "options";
    public static final String EXT = "ext";
    public static final String LEVEL = "level";
    public final Map<String, Object> metadata;

    public Parameter(String key, Class<T> type, String title, String description) {
        this(key, type, (InternationalString)new SimpleInternationalString(title), (InternationalString)new SimpleInternationalString(description));
    }

    public Parameter(String key, Class<T> type, String title, String description, Map<String, Object> metadata) {
        this(key, type, (InternationalString)new SimpleInternationalString(title), (InternationalString)new SimpleInternationalString(description), metadata);
    }

    public Parameter(String key, Class<T> type, InternationalString title, InternationalString description) {
        this(key, type, title, description, true, 1, 1, null, null);
    }

    public Parameter(String key, Class<T> type, InternationalString title, InternationalString description, Map<String, Object> metadata) {
        this(key, type, title, description, true, 1, 1, null, metadata);
    }

    public Parameter(String key, Class<T> type, InternationalString title, InternationalString description, boolean required, int min, int max, Object sample, Map<String, Object> metadata) {
        this.key = key;
        this.title = title;
        this.type = type;
        this.description = description;
        this.required = required;
        this.minOccurs = min;
        this.maxOccurs = max;
        this.sample = sample;
        this.metadata = metadata == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(metadata);
    }

    public Parameter(String key, Class<T> type) {
        this(key, type, null, null, true, 1, 1, null, null);
    }

    public Parameter(String key, Class<T> type, int min, int max) {
        this(key, type, null, null, min > 0, min, max, null, null);
    }

    public String getName() {
        return this.key;
    }

    public InternationalString getTitle() {
        return this.title;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public T getDefaultValue() {
        return (T)this.sample;
    }

    public boolean isPassword() {
        return this.metadata != null && Boolean.TRUE.equals(this.metadata.get(IS_PASSWORD));
    }

    public String getLevel() {
        if (this.metadata == null) {
            return "user";
        }
        String level = (String)this.metadata.get(LEVEL);
        if (level == null) {
            return "user";
        }
        return level;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append(this.key);
        if (this.type != Object.class) {
            build.append(":");
            build.append(this.type.getSimpleName());
        }
        if (!this.required) {
            build.append("{optional}");
        }
        if (this.minOccurs != 1 || this.maxOccurs != 1) {
            build.append("{");
            build.append(this.minOccurs);
            build.append(":");
            build.append(this.maxOccurs);
            build.append("}");
        }
        return build.toString();
    }
}

