/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.geotools.data.wfs.protocol.http.AbstractHttpProtocol;
import org.geotools.data.wfs.protocol.http.HTTPProtocol;
import org.geotools.data.wfs.protocol.http.HTTPResponse;
import org.geotools.factory.GeoTools;

public class DefaultHTTPProtocol
extends AbstractHttpProtocol
implements HTTPProtocol {
    private HttpClient client;

    @Override
    public HTTPResponse issuePost(URL targetUrl, final HTTPProtocol.POSTCallBack callback) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("About to issue POST request to " + targetUrl.toExternalForm());
        }
        String uri = targetUrl.toExternalForm();
        PostMethod postRequest = new PostMethod(uri);
        RequestEntity requestEntity = new RequestEntity(){

            public long getContentLength() {
                return callback.getContentLength();
            }

            public String getContentType() {
                return callback.getContentType();
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                callback.writeBody(out);
            }
        };
        postRequest.setRequestEntity(requestEntity);
        HTTPResponse httpResponse = this.issueRequest((HttpMethodBase)postRequest);
        return httpResponse;
    }

    @Override
    public HTTPResponse issueGet(URL baseUrl, Map<String, String> kvp) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("About to issue GET request to " + baseUrl.toExternalForm() + " with query parameters: " + kvp);
        }
        String uri = this.createUri(baseUrl, kvp);
        GetMethod getRequest = new GetMethod(uri);
        HTTPResponse httpResponse = this.issueRequest((HttpMethodBase)getRequest);
        return httpResponse;
    }

    private HTTPResponse issueRequest(HttpMethodBase httpRequest) throws IOException {
        int statusCode;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Executing HTTP request: " + httpRequest.getURI());
        }
        if (this.client == null) {
            this.client = new HttpClient();
            this.client.getParams().setParameter("http.useragent", (Object)("GeoTools " + GeoTools.getVersion() + " WFS DataStore"));
        }
        if (this.timeoutMillis > 0) {
            this.client.getParams().setSoTimeout(this.timeoutMillis);
        }
        System.err.println("Executing HTTP request: " + httpRequest);
        if (this.isTryGzip()) {
            LOGGER.finest("Adding 'Accept-Encoding=gzip' header to request");
            httpRequest.addRequestHeader("Accept-Encoding", "gzip");
        }
        try {
            statusCode = this.client.executeMethod((HttpMethod)httpRequest);
        }
        catch (IOException e) {
            httpRequest.releaseConnection();
            throw e;
        }
        if (statusCode != 200) {
            httpRequest.releaseConnection();
            String statusText = HttpStatus.getStatusText((int)statusCode);
            throw new IOException("Request failed with status code " + statusCode + "(" + statusText + "): " + httpRequest.getURI());
        }
        HTTPClientResponse httpResponse = new HTTPClientResponse(httpRequest);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Got " + httpResponse);
        }
        return httpResponse;
    }

    public class HTTPClientResponse
    implements HTTPResponse {
        private HttpMethodBase method;

        public HTTPClientResponse(HttpMethodBase method) {
            this.method = method;
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            InputStream responseStream = this.method.getResponseBodyAsStream();
            String encoding = this.getResponseHeader("Content-Encoding");
            if (encoding != null) {
                if (encoding.toLowerCase().indexOf("gzip") > -1) {
                    AbstractHttpProtocol.LOGGER.finest("Response is GZIP encoded, wrapping with gzip input stream");
                    responseStream = new GZIPInputStream(responseStream);
                }
            } else {
                AbstractHttpProtocol.LOGGER.finest("HTTP response is not gzip encoded");
            }
            final InputStream in = responseStream;
            InputStream releaseConnectionInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return in.read();
                }

                @Override
                public void close() throws IOException {
                    HTTPClientResponse.this.method.releaseConnection();
                }
            };
            return releaseConnectionInputStream;
        }

        @Override
        public String getContentType() {
            return this.getResponseHeader("Content-Type");
        }

        @Override
        public String getResponseCharset() {
            String responseCharSet = this.method.getResponseCharSet();
            return responseCharSet;
        }

        @Override
        public String getResponseHeader(String headerName) {
            Header header = this.method.getResponseHeader(headerName);
            String headerValue = null;
            if (header != null) {
                headerValue = header.getValue();
            }
            return headerValue;
        }

        @Override
        public String getTargetUrl() {
            try {
                URI uri = this.method.getURI();
                return uri.toString();
            }
            catch (URIException e) {
                AbstractHttpProtocol.LOGGER.log(Level.FINE, "can't get HTTP request URI", e);
                return null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("[Method=").append(this.method.getName());
            sb.append("\n\tHTTP version=").append(this.method.getEffectiveVersion());
            sb.append("\n\tstatus code=").append(this.method.getStatusCode());
            sb.append("\n\tpath=").append(this.method.getPath());
            sb.append("\n\tquery string=").append(this.method.getQueryString());
            sb.append("\n\tresponse charset=").append(this.getResponseCharset());
            Header[] responseHeaders = this.method.getResponseHeaders();
            sb.append("\n\tresponse headers=");
            for (Header header : responseHeaders) {
                sb.append(header.toExternalForm());
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

