/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.gml3.v3_2.GML;
import org.geotools.xs.XS;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

public class PropertyValueCollection
extends DecoratingFeatureCollection {
    static FeatureTypeFactory typeFactory = new FeatureTypeFactoryImpl();
    static FeatureFactory factory = CommonFactoryFinder.getFeatureFactory(null);
    AttributeDescriptor descriptor;
    List<Schema> typeMappingProfiles = new ArrayList<Schema>();

    public PropertyValueCollection(FeatureCollection delegate, AttributeDescriptor descriptor) {
        super(delegate);
        this.descriptor = descriptor;
        this.typeMappingProfiles.add(XS.getInstance().getTypeMappingProfile());
        this.typeMappingProfiles.add(GML.getInstance().getTypeMappingProfile());
    }

    public Iterator iterator() {
        return new PropertyValueIterator(this.delegate.iterator());
    }

    public void close(Iterator close) {
        this.delegate.close(((PropertyValueIterator)close).it);
    }

    class PropertyValueIterator
    implements Iterator {
        Iterator it;
        Feature next;

        PropertyValueIterator(Iterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (this.it.hasNext()) {
                    Feature f = (Feature)this.it.next();
                    if (f.getProperty(PropertyValueCollection.this.descriptor.getName()).getValue() == null) continue;
                    this.next = f;
                    break;
                }
            }
            return this.next != null;
        }

        public Object next() {
            AttributeType xmlType = this.findType(PropertyValueCollection.this.descriptor.getType().getBinding());
            if (xmlType == null) {
                throw new RuntimeException("Unable to map attribute " + PropertyValueCollection.this.descriptor.getName() + " to xml type");
            }
            Object value = this.next.getProperty(PropertyValueCollection.this.descriptor.getName()).getValue();
            NameImpl name = new NameImpl(this.next.getType().getName().getNamespaceURI(), PropertyValueCollection.this.descriptor.getLocalName());
            AttributeDescriptor newDescriptor = typeFactory.createAttributeDescriptor(xmlType, (Name)name, PropertyValueCollection.this.descriptor.getMinOccurs(), PropertyValueCollection.this.descriptor.getMaxOccurs(), PropertyValueCollection.this.descriptor.isNillable(), PropertyValueCollection.this.descriptor.getDefaultValue());
            this.next = null;
            return factory.createAttribute(value, newDescriptor, null);
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        AttributeType findType(Class binding) {
            for (Schema schema : PropertyValueCollection.this.typeMappingProfiles) {
                for (Map.Entry e : schema.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(binding)) continue;
                    return at;
                }
                for (AttributeType at : schema.values()) {
                    if (!binding.isAssignableFrom(at.getBinding())) continue;
                    return at;
                }
            }
            return null;
        }
    }
}

