/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;

public class MultithreadedHttpClient
implements HTTPClient {
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HttpClient client;
    private String user;
    private String password;

    public MultithreadedHttpClient() {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setSoTimeout(30000);
        params.setConnectionTimeout(30000);
        params.setMaxTotalConnections(6);
        params.setDefaultMaxConnectionsPerHost(6);
        this.connectionManager.setParams(params);
        this.client = new HttpClient((HttpConnectionManager)this.connectionManager);
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        PostMethod postMethod = new PostMethod(url.toExternalForm());
        postMethod.setDoAuthentication(this.user != null && this.password != null);
        if (postContentType != null) {
            postMethod.setRequestHeader("Content-type", postContentType);
        }
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(postContent);
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        int responseCode = this.client.executeMethod((HttpMethod)postMethod);
        if (200 != responseCode) {
            postMethod.releaseConnection();
            throw new IOException("Server returned HTTP error code " + responseCode + " for URL " + url.toExternalForm());
        }
        return new HttpMethodResponse((HttpMethod)postMethod);
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        GetMethod getMethod = new GetMethod(url.toExternalForm());
        getMethod.setDoAuthentication(this.user != null && this.password != null);
        int responseCode = this.client.executeMethod((HttpMethod)getMethod);
        if (200 != responseCode) {
            getMethod.releaseConnection();
            throw new IOException("Server returned HTTP error code " + responseCode + " for URL " + url.toExternalForm());
        }
        return new HttpMethodResponse((HttpMethod)getMethod);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
        this.resetCredentials();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.resetCredentials();
    }

    private void resetCredentials() {
        this.client.getState().clearCredentials();
        if (this.user != null && this.password != null) {
            AuthScope authscope = AuthScope.ANY;
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
            this.client.getParams().setAuthenticationPreemptive(true);
            this.client.getState().setCredentials(authscope, (Credentials)credentials);
        } else {
            this.client.getParams().setAuthenticationPreemptive(false);
        }
    }

    @Override
    public int getConnectTimeout() {
        return this.connectionManager.getParams().getConnectionTimeout() / 1000;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectionManager.getParams().setConnectionTimeout(connectTimeout * 1000);
    }

    @Override
    public int getReadTimeout() {
        return this.connectionManager.getParams().getSoTimeout() / 1000;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.connectionManager.getParams().setSoTimeout(readTimeout * 1000);
    }

    public int getMaxConnections() {
        return this.connectionManager.getParams().getDefaultMaxConnectionsPerHost();
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionManager.getParams().setMaxTotalConnections(maxConnections);
        this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxConnections);
    }

    private static class HttpMethodResponse
    implements HTTPResponse {
        private HttpMethod methodResponse;
        private InputStream responseBodyAsStream;

        public HttpMethodResponse(HttpMethod methodResponse) {
            this.methodResponse = methodResponse;
        }

        @Override
        public void dispose() {
            if (this.responseBodyAsStream != null) {
                try {
                    this.responseBodyAsStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.methodResponse != null) {
                this.methodResponse.releaseConnection();
                this.methodResponse = null;
            }
        }

        @Override
        public String getContentType() {
            return this.getResponseHeader("Content-Type");
        }

        @Override
        public String getResponseHeader(String headerName) {
            Header responseHeader = this.methodResponse.getResponseHeader(headerName);
            return responseHeader == null ? null : responseHeader.getValue();
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            if (this.responseBodyAsStream == null) {
                this.responseBodyAsStream = this.methodResponse.getResponseBodyAsStream();
            }
            return this.responseBodyAsStream;
        }
    }
}

