/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.geonetwork;

import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.geonetwork.GeoserverSortInterface;
import org.gcube.common.geoserverinterface.geonetwork.utils.InputStreamUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoserverDiscovery {
    private ArrayList<String> wmsGeoserverList = null;
    private ArrayList<String> wfsGeoserverList = null;
    private String mostUnloadWmsGeoserver = null;
    private int indexMostUnloadGeoserver;
    private GeoserverSortInterface sorter = null;
    private String xmlAllHarvestings = null;
    private String xmlWmsHarvestings = null;

    public GeoserverDiscovery(String xmlAllHarvestings) {
        this.loadGeoserverListsByHarvestings(xmlAllHarvestings);
    }

    public ArrayList<String> sortGeoserver(ArrayList<String> list) {
        ArrayList<String> orderList = new ArrayList();
        orderList = this.sorter.sortGeoserverList(list);
        return orderList;
    }

    public GeoserverSortInterface getSorter() {
        return this.sorter;
    }

    public void setSorter(GeoserverSortInterface sorter) {
        this.sorter = sorter;
    }

    private ArrayList<String> loadGeoserverList(GeonetworkCommonResourceInterface.GeoserverType serverType, String xmlHarvestings) {
        ArrayList<String> list = new ArrayList<String>();
        String serverTypeLC = serverType.toString().toLowerCase();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            String expression = "//url/text()[contains(.,'" + serverTypeLC + "')]";
            XPathExpression xPathExpression = xpath.compile(expression);
            InputSource inputSource = new InputSource(InputStreamUtil.stringToInputStream(xmlHarvestings));
            NodeList nodes = (NodeList)xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String[] spl = node.getTextContent().split("/" + serverTypeLC);
                list.add(spl[0]);
                ++i;
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public void reloadWmsGeoserverList(String xmlWmsHarvestings) {
        this.wmsGeoserverList = this.loadGeoserverList(GeonetworkCommonResourceInterface.GeoserverType.WMS, xmlWmsHarvestings);
    }

    public void reloadWfsGeoserverList(String xmlWfsHarvestings) {
        this.wfsGeoserverList = this.loadGeoserverList(GeonetworkCommonResourceInterface.GeoserverType.WFS, xmlWfsHarvestings);
    }

    public void loadGeoserverListsByHarvestings(String xmlAllHarvestings) {
        this.reloadWmsGeoserverList(xmlAllHarvestings);
        this.reloadWfsGeoserverList(xmlAllHarvestings);
        this.xmlAllHarvestings = xmlAllHarvestings;
    }

    public ArrayList<String> getWmsGeoserverList() {
        return this.wmsGeoserverList;
    }

    public ArrayList<String> getWfsGeoserverList() {
        return this.wfsGeoserverList;
    }
}

