/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.CoverageStoreRest;
import org.gcube.common.geoserverinterface.bean.CoverageTypeRest;
import org.gcube.common.geoserverinterface.bean.DataStoreRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.common.geoserverinterface.bean.WorkspaceRest;
import org.gcube.common.geoserverinterface.engine.GeoserverDeleteMethods;
import org.gcube.common.geoserverinterface.engine.GeoserverGetMethods;
import org.gcube.common.geoserverinterface.engine.GeoserverModifyMethods;
import org.gcube.common.geoserverinterface.engine.GeoserverPutMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoserverCaller {
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
    private HttpMethodCall HMC = null;
    private GeoserverGetMethods geoserverGetMethods = null;
    private GeoserverPutMethods geoserverPutMethods = null;
    private GeoserverModifyMethods geoserverModifyMethods = null;
    private GeoserverDeleteMethods geoserverDeleteMethods = null;

    public GeoserverCaller(String geoserver_url, String user, String password) {
        this.HMC = new HttpMethodCall(this.connectionManager, geoserver_url, user, password);
        this.geoserverGetMethods = new GeoserverGetMethods(this.HMC);
        this.geoserverPutMethods = new GeoserverPutMethods(this.HMC);
        this.geoserverModifyMethods = new GeoserverModifyMethods(this.HMC);
        this.geoserverDeleteMethods = new GeoserverDeleteMethods(this.HMC);
    }

    public GeoserverGetMethods getGeoserverGetMethods() {
        return this.geoserverGetMethods;
    }

    public GeoserverPutMethods getGeoserverPutMethods() {
        return this.geoserverPutMethods;
    }

    public GeoserverModifyMethods getGeoserverModifyMethods() {
        return this.geoserverModifyMethods;
    }

    public GeoserverDeleteMethods getGeoserverDeleteMethods() {
        return this.geoserverDeleteMethods;
    }

    public List<String> getLayerTitlesByWms(List<String> workspace, List<String> layerName) {
        List<String> res = null;
        try {
            res = this.geoserverGetMethods.getLayerTitleByWms(workspace, layerName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String getLayerTitleByWms(String workspace, String layerName) {
        String res = null;
        try {
            res = this.geoserverGetMethods.getLayerTitleByWms(workspace, layerName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public ArrayList<String> listWorkspaces() throws Exception {
        return this.geoserverGetMethods.listWorkspaces();
    }

    public WorkspaceRest getWorkspace(String wokspaceName) throws Exception {
        return this.geoserverGetMethods.getWorkspace(wokspaceName);
    }

    public List<String> listDataStores(String wokspaceName) throws Exception {
        return this.geoserverGetMethods.listDataStores(wokspaceName);
    }

    public DataStoreRest getDataStore(String wokspaceName, String dataStore) throws Exception {
        return this.geoserverGetMethods.getDataStore(wokspaceName, dataStore);
    }

    public ArrayList<String> listFeaturetypes(String wokspaceName, String dataStore) throws Exception {
        return this.geoserverGetMethods.listFeaturetypes(wokspaceName, dataStore);
    }

    public FeatureTypeRest getFeatureType(String wokspaceName, String dataStore, String featureType) throws Exception {
        return this.geoserverGetMethods.getFeatureType(wokspaceName, dataStore, featureType);
    }

    public CoverageTypeRest getCoverageType(String wokspaceName, String coveragestore, String coverageType) throws Exception {
        return this.geoserverGetMethods.getCoverageType(wokspaceName, coveragestore, coverageType);
    }

    public ArrayList<String> listLayers() throws Exception {
        return this.geoserverGetMethods.listLayers();
    }

    public LayerRest getLayer(String nameLayer) throws Exception {
        return this.geoserverGetMethods.getLayer(nameLayer);
    }

    public ArrayList<String> listLayerGroups() throws Exception {
        return this.geoserverGetMethods.listLayerGroups();
    }

    public GroupRest getLayerGroup(String nameGroup) throws Exception {
        return this.geoserverGetMethods.getLayerGroup(nameGroup);
    }

    public ArrayList<String> listStyles() throws Exception {
        return this.geoserverGetMethods.listStyles();
    }

    public ArrayList<String> listStyles(String layerName) throws Exception {
        return this.geoserverGetMethods.listStyles(layerName);
    }

    public InputStream getStyle(String styleName) throws Exception {
        return this.geoserverGetMethods.getStyle(styleName);
    }

    public List<String> listCoverageStores(String wokspaceName) throws Exception {
        return this.geoserverGetMethods.listCoverageStores(wokspaceName);
    }

    public CoverageStoreRest getCoverageStore(String wokspaceName, String coverageStore) throws Exception {
        return this.geoserverGetMethods.getCoverageStore(wokspaceName, coverageStore);
    }

    public ArrayList<String> listCoverages(String wokspaceName, String coverageStore) throws Exception {
        return this.geoserverGetMethods.listCoverages(wokspaceName, coverageStore);
    }

    public boolean addLayersGroup(GroupRest group) throws Exception {
        return this.geoserverPutMethods.addLayersGroup(group);
    }

    public boolean addFeatureType(FeatureTypeRest featureTypeRest) throws Exception {
        return this.geoserverPutMethods.addFeatureType(featureTypeRest);
    }

    public boolean addLayer(LayerRest layerRest) throws Exception {
        return this.geoserverPutMethods.addLayer(layerRest);
    }

    public boolean setLayer(FeatureTypeRest featureTypeRest, String defaultStyle, ArrayList<String> styles) throws Exception {
        return this.geoserverPutMethods.setLayer(featureTypeRest, defaultStyle, styles);
    }

    public boolean addStyleToLayer(String layer, String style) throws Exception {
        return this.geoserverPutMethods.addStyleToLayer(layer, style);
    }

    public boolean sendStyleSDL(String xmlSdl) throws Exception {
        return this.geoserverPutMethods.sendStyleSDL(xmlSdl);
    }

    public boolean modifyLayersGroup(GroupRest group) throws Exception {
        return this.geoserverModifyMethods.modifyLayersGroup(group);
    }

    public boolean modifyStyleSDL(String schemaName, String xmlSdl) throws Exception {
        return this.geoserverModifyMethods.modifyStyleSDL(schemaName, xmlSdl);
    }

    public boolean deleteLayersGroup(String name) throws Exception {
        return this.geoserverDeleteMethods.deleteLayersGroup(name);
    }

    public boolean deleteStyleSDL(String schemaName, boolean purge) throws Exception {
        return this.geoserverDeleteMethods.deleteStyleSDL(schemaName, purge);
    }

    public boolean deleteLayer(String LayerName) throws Exception {
        return this.geoserverDeleteMethods.deleteLayer(LayerName);
    }

    public boolean deleteFeatureTypes(String wokspaceName, String dataStore, String featureTypes) throws Exception {
        return this.geoserverDeleteMethods.deleteFeatureTypes(wokspaceName, dataStore, featureTypes);
    }
}

