/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.engine;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.common.geoserverinterface.json.JSONArray;
import org.gcube.common.geoserverinterface.json.JSONObject;

public class GeoserverPutMethods {
    private HttpMethodCall HMC = null;

    public GeoserverPutMethods(HttpMethodCall hMC) {
        this.HMC = hMC;
    }

    public boolean addLayersGroup(GroupRest group) throws Exception {
        JSONObject n;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", group.getName());
        JSONArray a = new JSONArray();
        for (String layer : group.getLayers()) {
            n = new JSONObject();
            n.put("name", layer);
            a.put(n);
        }
        Object l = new JSONObject();
        ((JSONObject)l).put("layer", a);
        m.put("layers", l);
        a = new JSONArray();
        for (String style : group.getStyles()) {
            n = new JSONObject();
            n.put("name", style);
            a.put(n);
        }
        l = new JSONObject();
        ((JSONObject)l).put("style", a);
        m.put("styles", l);
        JSONObject bounds = new JSONObject();
        bounds.put("minx", group.getBounds().getMinx());
        bounds.put("maxx", group.getBounds().getMaxx());
        bounds.put("miny", group.getBounds().getMiny());
        bounds.put("maxy", group.getBounds().getMaxy());
        bounds.put("crs", group.getBounds().getCrs());
        m.put("bounds", bounds);
        JSONObject j = new JSONObject();
        j.put("layerGroup", m);
        this.HMC.CallPost("rest/layergroups", j.toString(), "application/json");
        return true;
    }

    public boolean addFeatureType(FeatureTypeRest featureTypeRest) throws Exception {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", featureTypeRest.getName());
        m.put("nativeName", featureTypeRest.getNativeName());
        m.put("title", featureTypeRest.getTitle());
        m.put("srs", featureTypeRest.getSrs());
        m.put("projectionPolicy", featureTypeRest.getProjectionPolicy());
        m.put("enabled", featureTypeRest.isEnabled());
        JSONObject bounds = new JSONObject();
        bounds.put("minx", featureTypeRest.getNativeBoundingBox().getMinx());
        bounds.put("maxx", featureTypeRest.getNativeBoundingBox().getMaxx());
        bounds.put("miny", featureTypeRest.getNativeBoundingBox().getMiny());
        bounds.put("maxy", featureTypeRest.getNativeBoundingBox().getMaxy());
        bounds.put("crs", featureTypeRest.getNativeBoundingBox().getCrs());
        m.put("nativeBoundingBox", bounds);
        bounds = new JSONObject();
        bounds.put("minx", featureTypeRest.getLatLonBoundingBox().getMinx());
        bounds.put("maxx", featureTypeRest.getLatLonBoundingBox().getMaxx());
        bounds.put("miny", featureTypeRest.getLatLonBoundingBox().getMiny());
        bounds.put("maxy", featureTypeRest.getLatLonBoundingBox().getMaxy());
        bounds.put("crs", featureTypeRest.getLatLonBoundingBox().getCrs());
        m.put("latLonBoundingBox", bounds);
        JSONObject j = new JSONObject();
        j.put("featureType", m);
        this.HMC.CallPost("rest/workspaces/" + featureTypeRest.getWorkspace() + "/datastores/" + featureTypeRest.getDatastore() + "/featuretypes", j.toString(), "application/json");
        return this.HMC.isAvailableFeatureType("rest/workspaces/" + featureTypeRest.getWorkspace() + "/datastores/" + featureTypeRest.getDatastore() + "/featuretypes/" + featureTypeRest.getName() + ".json", 1, 8);
    }

    public boolean addLayer(LayerRest layerRest) throws Exception {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", layerRest.getName());
        m.put("type", layerRest.getName());
        m.put("enabled", layerRest.isEnabled());
        JSONObject defaultStyle = new JSONObject();
        defaultStyle.put("name", layerRest.getDefaultStyle());
        m.put("defaultStyle", defaultStyle);
        if (layerRest.getStyles().size() > 0) {
            JSONArray a = new JSONArray();
            for (String layer : layerRest.getStyles()) {
                JSONObject n = new JSONObject();
                n.put("name", layer);
                a.put(n);
            }
            JSONObject l = new JSONObject();
            l.put("style", a);
            m.put("styles", l);
        }
        JSONObject j = new JSONObject();
        j.put("layer", m);
        this.HMC.CallPut("rest/layers/" + layerRest.getName(), j.toString(), "application/json");
        return true;
    }

    public void addCoverageStore(final String storeName, final String type, final boolean enabled, final String workspace, final String urlFile) throws Exception {
        JSONObject jsObj = new JSONObject();
        jsObj.put("coverageStore", new HashMap<String, Object>(){
            {
                this.put("name", storeName);
                this.put("type", type);
                this.put("enabled", enabled);
                this.put("workspace", new HashMap<String, Object>(){
                    {
                        this.put("name", workspace);
                        this.put("href", GeoserverPutMethods.this.HMC.getUrlservice() + "/rest/workspaces/" + workspace + ".json");
                    }
                });
                this.put("url", urlFile);
            }
        });
        System.out.println("JSOBJ:\n" + jsObj.toString());
        String ris = this.HMC.CallPost("rest/workspaces/" + workspace + "/coveragestores", jsObj.toString(), "application/json");
        System.out.println("RIS: \n" + ris);
    }

    public boolean setLayer(FeatureTypeRest featureTypeRest, String defaultStyle, ArrayList<String> styles) throws Exception {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", featureTypeRest.getName());
        m.put("enabled", featureTypeRest.isEnabled());
        JSONObject defStyle = new JSONObject();
        defStyle.put("name", defaultStyle);
        m.put("defaultStyle", defStyle);
        if (styles.size() > 0) {
            JSONArray a = new JSONArray();
            for (String layer : styles) {
                JSONObject n = new JSONObject();
                n.put("name", layer);
                a.put(n);
            }
            JSONObject l = new JSONObject();
            l.put("style", a);
            m.put("styles", l);
        }
        JSONObject j = new JSONObject();
        j.put("layer", m);
        this.HMC.CallPut("rest/layers/" + featureTypeRest.getName(), j.toString(), "application/json");
        return true;
    }

    public boolean addStyleToLayer(String layer, String style) throws Exception {
        JSONObject n = new JSONObject();
        n.put("name", style);
        JSONObject j2 = new JSONObject();
        j2.put("style", n);
        this.HMC.CallPost("rest/layers/" + layer + "/styles", j2.toString(), "application/json");
        return true;
    }

    public boolean sendStyleSDL(String xmlSdl) throws Exception {
        return this.HMC.CallPost("rest/styles", xmlSdl, "application/vnd.ogc.sld+xml") != null;
    }
}

