/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.test;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.GeoserverCaller;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.common.geoserverinterface.json.JSONObject;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.exceptions.ConfigurationException;
import org.gcube.datatransfer.agent.library.exceptions.GetTransferOutcomesException;
import org.gcube.datatransfer.agent.library.exceptions.MonitorTransferException;
import org.gcube.datatransfer.agent.library.exceptions.TransferException;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;

public class TestRest {
    private static final String TRANSFER_STATE_DONE = "DONE";
    private static final Object GEOTIFF_TYPE = "GeoTIFF";
    static String geonetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork";
    static String geonetworkUsername = "admin";
    static String geonetworkPassword = "admin";
    static String geoserverUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver";
    static String geoserverUsername = "admin";
    static String geoserverPassword = "gcube@geo2010";
    static String SRS = "EPSG:4326";

    public static void main(String[] args) {
        TestRest.addGeoTiffTest();
    }

    private static void addGeoTiffTest2() {
        try {
            GeoCaller geoCaller = new GeoCaller(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUrl, geoserverUsername, geoserverPassword, GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
            boolean b = geoCaller.addPreExistentGeoTiff("p_edulis_map.tiff", "newEdulis1", "newEdulis1", "aquamaps", GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS, "descr", "");
            System.out.println("b=" + b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addGeoTiffTest() {
        try {
            GeoCaller geoCaller = new GeoCaller(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUrl, geoserverUsername, geoserverPassword, GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD);
            String workspace = "aquamapstest";
            String geoTiffUrl = "https://www.dropbox.com/s/ec68ssrkbm759ba/albers27.tif";
            String description = "albers test geotiff 0";
            String scope = "/gcube/devsec/";
            String layerName = "albers";
            String layerTitle = "albers title";
            String abstr = "albers abstr";
            geoCaller.addGeoTiff(geoTiffUrl, layerName, layerTitle, workspace, GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS, description, abstr, scope);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createLayerTest() {
        GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverMethodReserch = GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD;
        Object geoCaller = null;
        try {
            GeoserverCaller geoserverCaller = new GeoserverCaller(geoserverUrl, geoserverUsername, geoserverPassword);
            LayerRest layer = geoserverCaller.getLayer("eezall");
            System.out.println("name=" + layer.getName());
            System.out.println("ws=" + layer.getWorkspace());
            System.out.println("ds=" + layer.getDatastore());
            HttpMethodCall hmc = TestRest.initHmc();
            String workspaceName = "aquamaps";
            String storeName = "testGiamp";
            String fileName = "NLCD.2km.21600x10800.tif";
            JSONObject jsObj = new JSONObject();
            jsObj.put("coverageStore", new HashMap<String, Object>(){
                {
                    this.put("name", "testGiamp");
                    this.put("type", GEOTIFF_TYPE);
                    this.put("enabled", true);
                    this.put("workspace", new HashMap<String, Object>(){
                        {
                            this.put("name", "aquamaps");
                            this.put("href", geoserverUrl + "/rest/workspaces/" + "aquamaps" + ".json");
                        }
                    });
                    this.put("url", "file:data/aquamaps/NLCD.2km.21600x10800.tif");
                }
            });
            System.out.println("JSOBJ:\n" + jsObj.toString());
            String ris = hmc.CallPost("rest/workspaces/aquamaps/coveragestores", jsObj.toString(), "application/json");
            System.out.println("RIS: \n" + ris);
        }
        catch (Exception e) {
            System.out.println("Error, " + e.getMessage());
        }
    }

    private static void geoServerManagerTest() {
        try {
            GeoServerRESTPublisher publisher = new GeoServerRESTPublisher(geoserverUrl, geoserverUsername, geoserverPassword);
            File geotiff = new File("/usr/share/apache-tomcat-6.0.33/webapps/geoserver/data/data/aquamaps/p_edulis_map1.tiff");
            boolean b = publisher.publishExternalGeoTIFF("aquamaps", "p_edulis3_cs_P", geotiff, "p_edulis3_P", "EPSG:4326", GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED, "raster");
            System.out.println("\n\nBI = " + b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void geoCallerRestTest() {
        GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverMethodReserch = GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD;
        Object geoCaller = null;
        try {
            GeoserverCaller geoserverCaller = new GeoserverCaller(geoserverUrl, geoserverUsername, geoserverPassword);
            LayerRest layer = geoserverCaller.getLayer("eezall");
            System.out.println("name=" + layer.getName());
            System.out.println("ws=" + layer.getWorkspace());
            System.out.println("ds=" + layer.getDatastore());
            HttpMethodCall hmc = TestRest.initHmc();
            String workspaceName = "aquamaps";
            String storeName = "testGiamp";
            String fileName = "NLCD.2km.21600x10800.tif";
            String ris = hmc.Call("rest/workspaces/aquamaps/coveragestores.json");
            System.out.println("RIS: \n" + ris);
        }
        catch (Exception e) {
            System.out.println("Error, " + e.getMessage());
        }
    }

    private static void geoCallerRestCoverageStoreTest() {
        GeonetworkCommonResourceInterface.GeoserverMethodResearch geoserverMethodReserch = GeonetworkCommonResourceInterface.GeoserverMethodResearch.MOSTUNLOAD;
        Object geoCaller = null;
        try {
            GeoserverCaller geoserverCaller = new GeoserverCaller(geoserverUrl, geoserverUsername, geoserverPassword);
            LayerRest layer = geoserverCaller.getLayer("eezall");
            System.out.println("name=" + layer.getName());
            System.out.println("ws=" + layer.getWorkspace());
            System.out.println("ds=" + layer.getDatastore());
            HttpMethodCall hmc = TestRest.initHmc();
            String workspaceName = "aquamaps";
            String storeName = "testGiamp";
            String fileName = "NLCD.2km.21600x10800.tif";
            JSONObject jsObj = new JSONObject();
            jsObj.put("coverageStore", new HashMap<String, Object>(){
                {
                    this.put("name", "testGiamp");
                    this.put("type", GEOTIFF_TYPE);
                    this.put("enabled", true);
                    this.put("workspace", new HashMap<String, Object>(){
                        {
                            this.put("name", "aquamaps");
                            this.put("href", geoserverUrl + "/rest/workspaces/" + "aquamaps" + ".json");
                        }
                    });
                    this.put("url", "file:data/aquamaps/NLCD.2km.21600x10800.tif");
                }
            });
            System.out.println("JSOBJ:\n" + jsObj.toString());
            String ris = hmc.CallPost("rest/workspaces/aquamaps/coveragestores", jsObj.toString(), "application/json");
            System.out.println("RIS: \n" + ris);
        }
        catch (Exception e) {
            System.out.println("Error, " + e.getMessage());
        }
    }

    private static void dataTransferTest() {
        try {
            System.out.println("STARTED...");
            ScopeProvider.instance.set("/gcube/devsec/");
            AgentLibrary library = (AgentLibrary)Proxies.transferAgent().at("geoserver-dev.d4science-ii.research-infrastructures.eu", 9000).build();
            ArrayList<URI> inputs = new ArrayList<URI>();
            inputs.add(new URI("http://img821.imageshack.us/img821/6658/gisviewerdiagram.png"));
            inputs.add(new URI("http://img11.imageshack.us/img11/9008/geoexplorerdiagram.png"));
            inputs.add(new URI("https://www.dropbox.com/s/ec68ssrkbm759ba/albers27.tif"));
            String outPath = "./";
            TransferOptions options = new TransferOptions();
            options.setOverwriteFile(true);
            options.setType(Types.storageType.LocalGHN);
            options.setUnzipFile(false);
            String transferId = library.startTransfer(inputs, outPath, options);
            System.out.println("Transfer started " + transferId);
            String transferState = "";
            while (!transferState.contentEquals(TRANSFER_STATE_DONE)) {
                try {
                    transferState = library.monitorTransfer(transferId);
                    System.out.print(".");
                }
                catch (MonitorTransferException e) {
                    e.printStackTrace();
                }
                Thread.sleep(500L);
            }
            System.out.println("done!");
            ArrayList outcomes = library.getTransferOutcomes(transferId, FileTransferOutcome.class);
            for (FileTransferOutcome outcome : outcomes) {
                System.out.println("file: " + outcome.getDest() + "; " + (outcome.isSuccess() ? "SUCCESS" : "FAILURE"));
            }
        }
        catch (TransferException e) {
            System.out.println("TRANSFER EXCEPTION");
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            System.out.println("CONFIGURATION EXCEPTION");
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            System.out.println("URI SYNTAX EXCEPTION");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (GetTransferOutcomesException e) {
            e.printStackTrace();
        }
    }

    private static HttpMethodCall initHmc() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpMethodCall hmc = new HttpMethodCall(connectionManager, geoserverUrl, geoserverUsername, geoserverPassword);
        return hmc;
    }
}

