/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary.collections;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.xml.databases.existlibrary.collections.Collection;
import org.gcube.common.xml.databases.existlibrary.collections.CollectionImpl;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class SimpleCollection
extends CollectionImpl {
    public SimpleCollection(String name) {
        super(name);
    }

    public SimpleCollection(String name, org.xmldb.api.base.Collection collection) {
        super(name);
        this.setInternalCollection(collection);
    }

    @Override
    public void create(Collection parentColl) throws Collection.CollectionCreationException, Collection.CollectionAlreadyExistException {
        CollectionManagementService mgtService;
        logger.debug((Object)"create called on simple collection");
        if (this.getInternalCollection() != null) {
            throw new Collection.CollectionAlreadyExistException();
        }
        try {
            CollectionImpl parentCollImpl = (CollectionImpl)parentColl;
            mgtService = (CollectionManagementService)parentCollImpl.getInternalCollection().getService("CollectionManagementService", "1.0");
        }
        catch (XMLDBException e2) {
            throw new Collection.CollectionCreationException();
        }
        try {
            this.setInternalCollection(mgtService.createCollection(this.getName()));
        }
        catch (XMLDBException e) {
            try {
                mgtService.removeCollection(this.getName());
            }
            catch (XMLDBException e1) {
                // empty catch block
            }
            throw new Collection.CollectionCreationException();
        }
    }

    @Override
    public List<String> store(List<XMLResource> resources) throws Collection.CollectionException {
        ArrayList<String> toReturn = new ArrayList<String>();
        try {
            for (XMLResource resource : resources) {
                try {
                    this.getInternalCollection().storeResource((Resource)resource.getResource());
                }
                catch (XMLDBException e) {
                    logger.error((Object)e);
                    try {
                        toReturn.add(resource.getResource().getId());
                    }
                    catch (XMLDBException e1) {
                        toReturn.add("Unknow id");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing in a simple collection", (Throwable)e);
        }
        return toReturn;
    }

    @Override
    public XMLResource getResourceById(String id) throws Exception {
        return new XMLResource((org.xmldb.api.modules.XMLResource)this.getInternalCollection().getResource(id));
    }
}

