/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.xml.databases.existlibrary.collections;

import java.util.ArrayList;
import java.util.List;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XQueryService;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.common.xml.databases.existlibrary.ResultSetPool;
import org.gcube.common.xml.databases.existlibrary.UpdateEventConsumer;
import org.gcube.common.xml.databases.existlibrary.collections.Collection;
import org.gcube.common.xml.databases.existlibrary.collections.ExecuteXPathRSThread;
import org.gcube.common.xml.databases.existlibrary.collections.PartitionedCollection;
import org.gcube.common.xml.databases.existlibrary.collections.SimpleCollection;
import org.gcube.common.xml.databases.existlibrary.collections.XMLResource;
import org.gcube.common.xml.databases.existlibrary.thread.AddElementRSThread;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XPathQueryService;

public abstract class CollectionImpl
implements Collection {
    static GCUBELog logger = new GCUBELog(CollectionImpl.class);
    private String name;
    private org.xmldb.api.base.Collection internalCollection;

    protected org.xmldb.api.base.Collection getInternalCollection() {
        return this.internalCollection;
    }

    public CollectionImpl(String name) {
        this.name = name;
    }

    @Override
    public Collection openSubCollection(String collectionName) throws Collection.CollectionException {
        logger.debug((Object)("open subcollection " + collectionName));
        return this.getChildCollection(collectionName);
    }

    protected void setInternalCollection(org.xmldb.api.base.Collection internalCollection) {
        this.internalCollection = internalCollection;
    }

    @Override
    public void close() throws Collection.CollectionException {
        try {
            if (this.getInternalCollection() != null) {
                this.getInternalCollection().close();
            }
        }
        catch (XMLDBException e) {
            throw new Collection.CollectionException(e.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Service getService(String service, String version) throws Exception {
        return this.getInternalCollection().getService(service, service);
    }

    protected Collection getChildCollection(String childName) throws Collection.CollectionException {
        try {
            org.xmldb.api.base.Collection c = this.getInternalCollection().getChildCollection(childName);
            if (c != null) {
                CollectionImpl ret = c.getChildCollection("__sub__0") != null ? new PartitionedCollection(childName, c) : new SimpleCollection(childName, c);
                return ret;
            }
            logger.error((Object)("the sub-collection " + childName + " does not exist"));
            return null;
        }
        catch (XMLDBException e) {
            logger.error((Object)e);
            throw new Collection.CollectionException(e.getMessage());
        }
    }

    @Override
    public int getChildCollectionCount() throws Collection.CollectionException {
        try {
            return this.getInternalCollection().getChildCollectionCount();
        }
        catch (XMLDBException e) {
            throw new Collection.CollectionException();
        }
    }

    public abstract List<String> store(List<XMLResource> var1) throws Collection.CollectionException;

    @Override
    public List<String> removeElements(String[] toRemove) throws Collection.CollectionException {
        ArrayList<String> notRemoved = new ArrayList<String>();
        for (String resourceID : toRemove) {
            try {
                this.getInternalCollection().removeResource(this.internalCollection.getResource(resourceID));
            }
            catch (XMLDBException e) {
                notRemoved.add(resourceID);
            }
        }
        return notRemoved;
    }

    public XMLResource createResource(String name, Object content, String Type2) throws XMLDBException {
        XMLResource res = new XMLResource((org.xmldb.api.modules.XMLResource)this.getInternalCollection().createResource(name, Type2));
        res.setContent(content);
        return res;
    }

    protected String[] getChildsCollection() throws XMLDBException {
        String[] toReturn = null;
        try {
            toReturn = ((LocalCollection)this.internalCollection).getChildCollections();
        }
        catch (XMLDBException e) {
            logger.error((Object)e);
            throw e;
        }
        return toReturn;
    }

    @Override
    public Collection createCollection(String collectionName) throws Collection.CollectionAlreadyExistException, Collection.CollectionCreationException {
        return this._createCollection(collectionName, CollectionType.SIMPLE);
    }

    @Override
    public Collection createPartitionedCollection(String collectionName) throws Collection.CollectionAlreadyExistException, Collection.CollectionCreationException {
        logger.debug((Object)"create partitioned collection in CollectionImpl");
        return this._createCollection(collectionName, CollectionType.PARTITIONED);
    }

    private Collection _createCollection(String collectionName, CollectionType type) throws Collection.CollectionAlreadyExistException, Collection.CollectionCreationException {
        logger.trace((Object)"_createCollection method");
        try {
            if (this.openSubCollection(collectionName) != null) {
                logger.info((Object)"the collection already exists!!");
                throw new Collection.CollectionAlreadyExistException("the collection already exists!!");
            }
            CollectionImpl ret = null;
            switch (type) {
                case SIMPLE: {
                    ret = new SimpleCollection(collectionName);
                    break;
                }
                case PARTITIONED: {
                    ret = new PartitionedCollection(collectionName);
                }
            }
            if (ret != null) {
                logger.trace((Object)("calling create on the collection " + ret.getClass().getName()));
                ret.create(this);
                return ret;
            }
            throw new Collection.CollectionCreationException("error creating resource");
        }
        catch (Exception e) {
            logger.error((Object)"error creating collection in _createCollection", (Throwable)e);
            throw new Collection.CollectionCreationException("error creating collection in _createCollection");
        }
    }

    @Override
    public List<String> executeXQueryDirect(String xQuery) throws Exception {
        XQueryService service = (XQueryService)this.getService("XQueryService", "1.0");
        CompiledExpression compiled = service.compile(xQuery);
        long start = System.currentTimeMillis();
        ResourceSet result = service.execute(compiled);
        long stop = System.currentTimeMillis();
        ResourceIterator resIt = result.getIterator();
        ArrayList<String> toReturn = new ArrayList<String>();
        while (resIt.hasMoreResources()) {
            toReturn.add((String)resIt.nextResource().getContent());
        }
        logger.debug((Object)("XQuery Direct kept " + (stop - start) / 1000L + " s"));
        return toReturn;
    }

    @Override
    public String executeXQueryInDirect(String xQuery) throws Exception {
        RSXMLWriter writer = ResultSetPool.getResultSetPoolInstance().getResultSetFactory().getRSXMLWriter();
        String toReturn = writer.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
        new ExecuteXPathRSThread(writer, xQuery, this).start();
        return toReturn;
    }

    @Override
    public String executeXPathIndirect(String xPath) throws Exception {
        String toReturn = null;
        RSXMLWriter writer = ResultSetPool.getResultSetPoolInstance().getResultSetFactory().getRSXMLWriter();
        toReturn = writer.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
        new ExecuteXPathRSThread(writer, xPath, this).start();
        return toReturn;
    }

    @Override
    public List<String> executeXPathDirect(String xPath) throws Exception {
        logger.trace((Object)"executeXPathDirect");
        XPathQueryService service = (XPathQueryService)this.getService("XPathQueryService", "2.0");
        if (service == null) {
            throw new Exception("unble to get the XPathQueryService from the database instance");
        }
        long start = System.currentTimeMillis();
        ResourceSet resSet = service.query(xPath);
        long stop = System.currentTimeMillis();
        ResourceIterator resIt = resSet.getIterator();
        ArrayList<String> toReturn = new ArrayList<String>();
        while (resIt.hasMoreResources()) {
            toReturn.add((String)resIt.nextResource().getContent());
        }
        logger.debug((Object)("Xpath Direct kept " + (stop - start) / 1000L + " s"));
        return toReturn;
    }

    @Override
    public void deleteCollection(String collectionName) throws Collection.CollectionException {
        try {
            CollectionManagementService mgtService = (CollectionManagementService)this.getService("CollectionManagementService", "1.0");
            mgtService.removeCollection(collectionName);
        }
        catch (Exception e) {
            throw new Collection.CollectionException();
        }
    }

    public Collection getCurrentCollection() {
        return this;
    }

    @Override
    public void AddElementByResultSet(String Locator, UpdateEventConsumer consumer) {
        new AddElementRSThread(Locator, this, consumer).start();
        logger.debug((Object)"Thread AddElement started");
    }

    @Override
    public List<String> AddElement(List<XMLResource> listResources) throws Exception {
        return this.store(listResources);
    }

    public static enum CollectionType {
        PARTITIONED,
        SIMPLE;

    }
}

