/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import org.gcube.event.publisher.ConductorResultsParser;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventPublisher;
import org.gcube.event.publisher.EventSender;
import org.gcube.event.publisher.EventStatus;
import org.gcube.event.publisher.ResultsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventPublisher
implements EventPublisher {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractEventPublisher.class);
    private EventSender eventSender = this.createEventSender();
    private ResultsParser resultsParser = this.createResultsParser();

    @Override
    public void publish(Event event) {
        this.publish(event, false);
    }

    @Override
    public String publish(Event event, boolean waitForResult) {
        if (event != null) {
            if (waitForResult) {
                return this.getEventSender().sendAndGetResult(event);
            }
            this.getEventSender().send(event);
        } else {
            logger.warn("Cannot publish a null event");
        }
        return null;
    }

    @Override
    public boolean isLastPublishOK() {
        return this.getLastPublishEventHTTPResponseCode() == 200 || this.getLastPublishEventHTTPResponseCode() == 201;
    }

    @Override
    public int getLastPublishEventHTTPResponseCode() {
        return this.eventSender.getLastSendHTTPResponseCode();
    }

    @Override
    public EventStatus publishAndCheck(Event event) {
        return this.publishAndCheck(event, 0);
    }

    @Override
    public EventStatus publishAndCheck(Event event, int delayMS) {
        String instanceId = this.publish(event, true);
        try {
            if (delayMS > 0) {
                Thread.sleep(delayMS);
            }
            return this.check(instanceId);
        }
        catch (InterruptedException e) {
            logger.error("Sleeping before performing the event status check", (Throwable)e);
            return null;
        }
    }

    @Override
    public EventStatus check(String instanceId) {
        if (instanceId != null) {
            return this.getResultsParser().parseResults(instanceId, this.eventSender.retrive(instanceId));
        }
        logger.warn("Cannot check with a null instance ID");
        return EventStatus.NOT_FOUND(instanceId);
    }

    @Override
    public EventStatus refresh(EventStatus eventStatus) {
        return this.check(eventStatus.getInstanceId());
    }

    @Override
    public boolean isLastCheckOK() {
        return this.getLastCheckHTTPResponseCode() == 200;
    }

    @Override
    public int getLastCheckHTTPResponseCode() {
        return this.eventSender.getLastRetrieveHTTPResponseCode();
    }

    protected abstract EventSender createEventSender();

    protected ResultsParser createResultsParser() {
        return new ConductorResultsParser();
    }

    public EventSender getEventSender() {
        return this.eventSender;
    }

    public void setEventSender(EventSender eventSender) {
        this.eventSender = eventSender;
    }

    public ResultsParser getResultsParser() {
        return this.resultsParser;
    }

    public void setResultsParser(ResultsParser resultsParser) {
        this.resultsParser = resultsParser;
    }
}

