/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventPublisher;
import org.gcube.event.publisher.EventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventPublisher
implements EventPublisher {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractEventPublisher.class);
    private EventSender eventSender = this.createEventSender();

    @Override
    public void publish(Event event) {
        if (event != null) {
            this.eventSender.send(event);
        } else {
            logger.warn("Cannot post null event");
        }
    }

    protected abstract EventSender createEventSender();

    public EventSender getEventSender() {
        return this.eventSender;
    }

    public void setEventSender(EventSender eventSender) {
        this.eventSender = eventSender;
    }
}

