/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.TableAlreadyExistsException;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.persistence.ObjectStateChangedException;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.PersistencyCallback;
import org.gcube.common.dbinterface.persistence.SystemTableInfo;
import org.gcube.common.dbinterface.persistence.annotations.AnnotationNotDefinedException;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTable;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.DropTable;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Update;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPersistency<T> {
    public static HashMap<String, ObjectPersistency> persistencyMapping = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(ObjectPersistency.class);
    private static final String FIELD_PREFIX = "ifield";
    private Class<T> _clazz;
    private SimpleTable table;
    private List<PersistencyCallback<T>> callbacks = new ArrayList<PersistencyCallback<T>>();

    public void addCallback(PersistencyCallback<T> obj) {
        this.callbacks.add(obj);
    }

    public static <T> ObjectPersistency<T> get(Class<T> clazz) throws Exception {
        if (!persistencyMapping.containsKey(clazz.getName())) {
            persistencyMapping.put(clazz.getName(), new ObjectPersistency<T>(clazz));
        }
        return persistencyMapping.get(clazz.getName());
    }

    private ObjectPersistency(Class<T> clazz) throws Exception {
        this._clazz = clazz;
        if (!this._clazz.isAnnotationPresent(TableRootDefinition.class)) {
            throw new AnnotationNotDefinedException();
        }
        String tableName = clazz.getSimpleName() + Math.abs(clazz.getName().hashCode());
        try {
            this.table = this.createTable(tableName);
        }
        catch (TableAlreadyExistsException e) {
            this.table = new SimpleTable(tableName);
        }
    }

    private FieldMappingPair retrieveColumnDefinition(Class _clazz, int fieldIndex) throws Exception {
        ArrayList<ColumnDefinition> cdList = new ArrayList<ColumnDefinition>();
        TreeMap<String, String> internalFieldMapping = new TreeMap<String, String>();
        logger.trace("retrieving column definition for --> table " + _clazz.getSimpleName());
        for (Field field : _clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(FieldDefinition.class)) continue;
            FieldDefinition fieldDefinition = field.getAnnotation(FieldDefinition.class);
            ColumnDefinition cDef = DBSession.getImplementation(ColumnDefinition.class);
            String fieldNameInTable = FIELD_PREFIX + fieldIndex;
            cDef.setLabel(fieldNameInTable);
            Type type = Type.getTypeByJavaClass(field.getType());
            if (type == null || type.getType() == Type.Types.STRING && fieldDefinition.precision().length == 0) {
                type = new Type(Type.Types.TEXT, new int[0]);
            } else {
                type.setPrecision(fieldDefinition.precision());
            }
            logger.trace(field.getName() + " --> the type " + field.getType() + " is converted in  " + type.getType().name());
            cDef.setType(type);
            cDef.setSpecification(fieldDefinition.specifications());
            cdList.add(cDef);
            internalFieldMapping.put(field.getName(), fieldNameInTable);
            ++fieldIndex;
        }
        if (_clazz.getSuperclass() != null) {
            if (_clazz.getSuperclass().equals(ObjectStateControl.class)) {
                ColumnDefinition cDef = DBSession.getImplementation(ColumnDefinition.class);
                cDef.setLabel("objectversion");
                Type type = new Type(Type.Types.INTEGER, new int[0]);
                type.setPrecision(10);
                cDef.setType(type);
                cdList.add(cDef);
            } else {
                FieldMappingPair fmPair = this.retrieveColumnDefinition(_clazz.getSuperclass(), fieldIndex);
                cdList.addAll(fmPair.getColumnsDefinition());
                internalFieldMapping.putAll(fmPair.getFieldMapping());
            }
        }
        return new FieldMappingPair(internalFieldMapping, cdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleTable createTable(String tableName) throws Exception {
        CreateTable creator = DBSession.getImplementation(CreateTable.class);
        FieldMappingPair fmPair = this.retrieveColumnDefinition(this._clazz, 0);
        creator.setColumnsDefinition(fmPair.getColumnsDefinition().toArray(new ColumnDefinition[fmPair.getColumnsDefinition().size()]));
        creator.setTableName(tableName);
        DBSession session = null;
        try {
            session = DBSession.connect();
            logger.trace(creator.getExpression());
            this.table = creator.execute(session);
            SystemTableInfo.getSystemInfo().addInfo(fmPair.getFieldMapping(), this.table.getTableName());
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByKey(Object key) throws Exception {
        LinkedHashMap<String, Type> mapping = this.table.getFieldsMapping();
        String primaryKey = null;
        Type type = null;
        for (Map.Entry<String, Type> entry : mapping.entrySet()) {
            if (!entry.getValue().isPrimaryKey()) continue;
            primaryKey = entry.getKey();
            type = (Type)entry.getValue();
            break;
        }
        if (this.callbacks.size() > 0) {
            T obj = this.getByKey(key);
            for (PersistencyCallback persistencyCallback : this.callbacks) {
                persistencyCallback.onObjectDeleted(obj);
            }
        }
        Delete delete = DBSession.getImplementation(Delete.class);
        CastObject cast = DBSession.getImplementation(CastObject.class);
        cast.setStringValue(key.toString());
        cast.setType(type);
        delete.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(primaryKey), cast, "="));
        delete.setTable(this.table);
        DBSession dBSession = DBSession.connect();
        try {
            delete.execute(dBSession);
        }
        finally {
            dBSession.release();
        }
        if (delete.getDeletedItems() == 0) {
            throw new ObjectNotFoundException();
        }
    }

    public Map<String, String> getInfo() throws Exception {
        return SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByKey(Object key) throws ObjectNotFoundException, Exception {
        T toReturn;
        block7: {
            LinkedHashMap<String, Type> mapping = this.table.getFieldsMapping();
            String primaryKey = null;
            Type type = null;
            for (Map.Entry<String, Type> entry : mapping.entrySet()) {
                if (!entry.getValue().isPrimaryKey()) continue;
                primaryKey = entry.getKey();
                type = entry.getValue();
                break;
            }
            if (type == null) {
                throw new Exception("no primary key found in " + this.table.getTableName());
            }
            Select select = DBSession.getImplementation(Select.class);
            CastObject cast = DBSession.getImplementation(CastObject.class);
            cast.setStringValue(key.toString());
            cast.setType(type);
            select.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(primaryKey), cast, "="));
            select.setTables(this.table);
            toReturn = null;
            DBSession session = null;
            try {
                session = DBSession.connect();
                ResultSet result = select.getResults(session, new boolean[0]);
                if (result.next()) {
                    toReturn = this.createObject(result);
                    break block7;
                }
                throw new ObjectNotFoundException();
            }
            finally {
                if (session != null) {
                    session.release();
                }
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(T object) throws Exception {
        for (PersistencyCallback<T> callback : this.callbacks) {
            callback.onBeforeStore(object);
        }
        Insert insertor = DBSession.getImplementation(Insert.class);
        insertor.setTable(this.table);
        List<Object> oInsert = this.retrieveInsertField(object, this._clazz);
        insertor.setInsertValues(oInsert.toArray(new Object[oInsert.size()]));
        DBSession session = DBSession.connect();
        try {
            insertor.execute(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        for (PersistencyCallback<T> callback : this.callbacks) {
            callback.onObjectStored(object);
        }
    }

    private List<Object> retrieveInsertField(T object, Class clazz) throws Exception {
        ArrayList<Object> oInsert = new ArrayList<Object>();
        logger.trace("storing class " + clazz.getSimpleName());
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(FieldDefinition.class)) continue;
            if (Type.getTypeByJavaClass(field.getType()) == null) {
                logger.trace(field.getName() + " - " + field.getType());
                field.setAccessible(true);
                oInsert.add(new XStream().toXML(field.get(object)));
                continue;
            }
            logger.trace(field.getName() + " - " + field.getType());
            field.setAccessible(true);
            oInsert.add(field.get(object));
        }
        if (clazz.getSuperclass() != null) {
            if (clazz.getSuperclass().equals(ObjectStateControl.class)) {
                oInsert.add(0);
            } else if (clazz.getSuperclass().isAnnotationPresent(TableRootDefinition.class)) {
                oInsert.addAll(this.retrieveInsertField(object, clazz.getSuperclass()));
            }
        }
        return oInsert;
    }

    public void drop() throws Exception {
        DBSession session = DBSession.connect();
        DropTable drop = DBSession.getImplementation(DropTable.class);
        drop.setTableName(this.table.getTableName());
        try {
            drop.execute(session);
            SystemTableInfo.getSystemInfo().deleteInfo(this.table.getTableName());
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByValue(String fieldName, Object value) throws Exception {
        DBSession session = DBSession.connect();
        Delete delete = DBSession.getImplementation(Delete.class);
        delete.setTable(this.table);
        String internalFieldName = SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName()).get(fieldName);
        if (internalFieldName == null) {
            throw new Exception("field " + fieldName + " non retrieved");
        }
        if (this.callbacks.size() > 0) {
            Iterator<T> it = this.getObjectByField(fieldName, value).iterator();
            while (it.hasNext()) {
                for (PersistencyCallback<T> callback : this.callbacks) {
                    callback.onObjectDeleted(it.next());
                }
            }
        }
        delete.setFilter(new OperatorCondition<SimpleAttribute, Object>(new SimpleAttribute(internalFieldName), value, "="));
        try {
            delete.execute(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public List<T> getObjectByField(String fieldName, Object value) throws Exception {
        Select select = DBSession.getImplementation(Select.class);
        String internalFieldName = SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName()).get(fieldName);
        if (internalFieldName == null) {
            throw new Exception("field " + fieldName + " non retrieved");
        }
        select.setFilter(new OperatorCondition<SimpleAttribute, Object>(new SimpleAttribute(internalFieldName), value, "="));
        select.setTables(this.table);
        DBSession session = DBSession.connect();
        return this.toList(select.getResults(session, new boolean[0]));
    }

    public List<T> getObjectByFields(HashMap<String, Object> fieldValueMapping) throws Exception {
        if (fieldValueMapping.isEmpty()) {
            throw new Exception("the filedValueMapping is empty");
        }
        Select select = DBSession.getImplementation(Select.class);
        ArrayList<OperatorCondition<SimpleAttribute, Object>> conditions = new ArrayList<OperatorCondition<SimpleAttribute, Object>>();
        for (Map.Entry<String, Object> entry : fieldValueMapping.entrySet()) {
            String internalFieldName = SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName()).get(entry.getKey());
            if (internalFieldName == null) {
                throw new Exception("field " + entry.getKey() + " non retrieved");
            }
            conditions.add(new OperatorCondition<SimpleAttribute, Object>(new SimpleAttribute(internalFieldName), entry.getValue(), "="));
        }
        select.setFilter(new ANDCondition(conditions.toArray(new OperatorCondition[conditions.size()])));
        select.setTables(this.table);
        DBSession session = DBSession.connect();
        return this.toList(select.getResults(session, new boolean[0]));
    }

    public List<T> getAll() throws Exception {
        Select select = DBSession.getImplementation(Select.class);
        select.setTables(this.table);
        DBSession session = DBSession.connect();
        return this.toList(select.getResults(session, new boolean[0]));
    }

    public SimpleTable getTable() {
        return this.table;
    }

    public boolean existsKey(Object key) throws Exception {
        DBSession session = null;
        try {
            LinkedHashMap<String, Type> mapping = this.table.getFieldsMapping();
            String primaryKey = null;
            Type type = null;
            for (Map.Entry<String, Type> entry : mapping.entrySet()) {
                if (!entry.getValue().isPrimaryKey()) continue;
                primaryKey = entry.getKey();
                type = entry.getValue();
                break;
            }
            if (type == null) {
                throw new ObjectNotFoundException("no primary key found in " + this.table.getTableName());
            }
            Select select = DBSession.getImplementation(Select.class);
            CastObject cast = DBSession.getImplementation(CastObject.class);
            cast.setStringValue(key.toString());
            cast.setType(type);
            select.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(primaryKey), cast, "="));
            select.setTables(this.table);
            session = DBSession.connect();
            ResultSet result = select.getResults(session, new boolean[0]);
            if (result.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("errror retrieving key", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public boolean existEntryByFields(HashMap<String, Object> fieldValueMapping) throws Exception {
        if (fieldValueMapping.isEmpty()) {
            throw new Exception("the filedValueMapping is empty");
        }
        Select select = DBSession.getImplementation(Select.class);
        ArrayList<OperatorCondition<SimpleAttribute, Object>> conditions = new ArrayList<OperatorCondition<SimpleAttribute, Object>>();
        for (Map.Entry<String, Object> entry : fieldValueMapping.entrySet()) {
            String internalFieldName = SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName()).get(entry.getKey());
            if (internalFieldName == null) {
                throw new Exception("field " + entry.getKey() + " non retrieved");
            }
            conditions.add(new OperatorCondition<SimpleAttribute, Object>(new SimpleAttribute(internalFieldName), entry.getValue(), "="));
        }
        select.setFilter(new ANDCondition(conditions.toArray(new OperatorCondition[conditions.size()])));
        select.setTables(this.table);
        return select.getResults(false).next();
    }

    public void update(T obj) throws ObjectStateChangedException, ObjectNotFoundException, Exception {
        LinkedHashMap<String, Type> mapping = this.table.getFieldsMapping();
        OperatorCondition<SimpleAttribute, CastObject> primaryKeyOperator = null;
        String primaryKey = null;
        Type type = null;
        for (Map.Entry<String, Type> entry : mapping.entrySet()) {
            if (!entry.getValue().isPrimaryKey()) continue;
            primaryKey = entry.getKey();
            type = entry.getValue();
            break;
        }
        if (type == null) {
            throw new ObjectNotFoundException("no primary key found in " + this.table.getTableName());
        }
        Object keyValue = this.getFieldValue(obj, SystemTableInfo.getSystemInfo().retrieveFieldName(this.table.getTableName(), primaryKey), type);
        CastObject cast = DBSession.getImplementation(CastObject.class);
        cast.setStringValue(keyValue != null ? keyValue.toString() : null);
        cast.setType(type);
        primaryKeyOperator = new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(primaryKey), cast, "=");
        this.executeUpdate(obj, primaryKeyOperator);
    }

    public void updateByFields(T obj, HashMap<String, Object> fieldValueMapping) throws ObjectStateChangedException, ObjectNotFoundException, Exception {
        if (fieldValueMapping.isEmpty()) {
            throw new Exception("the filedValueMapping is empty");
        }
        ArrayList<OperatorCondition<SimpleAttribute, Object>> conditions = new ArrayList<OperatorCondition<SimpleAttribute, Object>>();
        Update update = DBSession.getImplementation(Update.class);
        update.setTable(this.table);
        for (Map.Entry<String, Object> entry : fieldValueMapping.entrySet()) {
            String internalFieldName = SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName()).get(entry.getKey());
            if (internalFieldName == null) {
                throw new Exception("field " + entry.getKey() + " non retrieved");
            }
            conditions.add(new OperatorCondition<SimpleAttribute, Object>(new SimpleAttribute(internalFieldName), entry.getValue(), "="));
        }
        this.executeUpdate(obj, new ANDCondition(conditions.toArray(new OperatorCondition[conditions.size()])));
    }

    private Object getFieldValue(T obj, String fieldName, Type internalType) throws Exception {
        Field field = this.retrieveField(fieldName, this._clazz);
        field.setAccessible(true);
        Object fieldValue = null;
        if (internalType.getType().getJavaClass().isPrimitive()) {
            Method fieldMethod = Field.class.getDeclaredMethod(internalType.getType().getReflectionMethodGet(), Object.class);
            fieldValue = fieldMethod.invoke((Object)field, obj);
        } else {
            fieldValue = field.getType().isEnum() ? field.get(obj).toString() : (Type.getTypeByJavaClass(field.getType()) == null ? new XStream().toXML(field.get(obj)) : field.get(obj));
        }
        return fieldValue;
    }

    private void executeUpdate(T obj, Condition filter) throws ObjectStateChangedException, ObjectNotFoundException, Exception {
        LinkedHashMap<String, Type> mapping = this.table.getFieldsMapping();
        ArrayList<OperatorCondition<SimpleAttribute, Serializable>> setters = new ArrayList<OperatorCondition<SimpleAttribute, Serializable>>();
        for (Map.Entry<String, String> entry : SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName()).entrySet()) {
            Type internaltype = mapping.get(entry.getValue());
            if (internaltype.isPrimaryKey()) continue;
            CastObject cast = DBSession.getImplementation(CastObject.class);
            Object fieldValue = this.getFieldValue(obj, entry.getKey(), internaltype);
            cast.setStringValue(fieldValue != null ? fieldValue.toString() : null);
            cast.setType(internaltype);
            setters.add(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(entry.getValue()), cast, "="));
        }
        DBSession session = DBSession.connect();
        session.disableAutoCommit();
        Update update = DBSession.getImplementation(Update.class);
        update.setTable(this.table);
        update.setFilter(filter);
        try {
            Select select = DBSession.getImplementation(Select.class);
            select.setTables(this.table);
            select.setFilter(filter);
            if (!select.getResults(new boolean[0]).next()) {
                throw new ObjectNotFoundException();
            }
            if (this.isUnderVersionControl()) {
                Field field = ObjectStateControl.class.getDeclaredField("objectversion");
                field.setAccessible(true);
                int versionValue = field.getInt(obj);
                OperatorCondition<SimpleAttribute, Integer> versionControl = new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute("objectversion"), versionValue, "=");
                update.setFilter(new ANDCondition(filter, versionControl));
                setters.add(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute("objectversion"), versionValue + 1, "="));
                field.setInt(obj, versionValue + 1);
            }
            update.setOperators(setters.toArray(new OperatorCondition[setters.size()]));
            update.execute(session);
            session.commit();
            if (update.getAffectedLines() == 0) {
                throw new ObjectStateChangedException();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            session.release();
        }
        if (obj != null) {
            for (PersistencyCallback<T> callback : this.callbacks) {
                callback.onObjectUpdated(obj);
            }
        }
    }

    private Field retrieveField(String fieldName, Class clazz) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                if (clazz.getSuperclass() == null || !clazz.getSuperclass().isAnnotationPresent(TableRootDefinition.class)) break block2;
                return this.retrieveField(fieldName, clazz.getSuperclass());
            }
        }
        return field;
    }

    private boolean isUnderVersionControl() {
        Class<T> clazz = this._clazz;
        while ((clazz = clazz.getSuperclass()) != null) {
            if (!clazz.equals(ObjectStateControl.class)) continue;
            return true;
        }
        return false;
    }

    private List<T> toList(ResultSet resultSet) throws Exception {
        ArrayList<T> returnList = new ArrayList<T>();
        while (resultSet.next()) {
            returnList.add(this.createObject(resultSet));
        }
        resultSet.close();
        return returnList;
    }

    private T createObject(ResultSet result) throws Exception {
        Constructor<T> constr = this._clazz.getDeclaredConstructor(new Class[0]);
        logger.debug("createObjectInternal with class " + this._clazz.getName());
        constr.setAccessible(true);
        T returnObj = constr.newInstance(new Object[0]);
        this.table.initializeFieldMapping();
        LinkedHashMap<String, Type> mapping = this.table.getFieldsMapping();
        TreeMap<String, String> classTableMap = SystemTableInfo.getSystemInfo().retrieveInfo(this.table.getTableName());
        this.createObjectInternal(this._clazz, mapping, returnObj, classTableMap, result);
        if (returnObj != null) {
            for (PersistencyCallback<T> callback : this.callbacks) {
                callback.onObjectLoaded(returnObj);
            }
        }
        return returnObj;
    }

    private void createObjectInternal(Class clazz, LinkedHashMap<String, Type> mapping, T returnObj, Map<String, String> classTableMap, ResultSet result) throws Exception {
        for (Field field : clazz.getDeclaredFields()) {
            Method rsMethod;
            String internalFieldName = classTableMap.get(field.getName());
            if (internalFieldName == null) continue;
            field.setAccessible(true);
            logger.trace("fieldName is " + field.getName());
            if (mapping.get(internalFieldName).getType().getJavaClass().isPrimitive()) {
                rsMethod = ResultSet.class.getDeclaredMethod(mapping.get(internalFieldName).getType().getReflectionMethodGet(), String.class);
                Method fieldMethod = Field.class.getDeclaredMethod(mapping.get(internalFieldName).getType().getReflectionMethodSet(), Object.class, mapping.get(internalFieldName).getType().getJavaClass());
                fieldMethod.invoke((Object)field, returnObj, rsMethod.invoke((Object)result, internalFieldName));
                continue;
            }
            if (field.getType().isEnum()) {
                String value = result.getString(internalFieldName);
                field.set(returnObj, Enum.valueOf(field.getType(), value));
                continue;
            }
            if (Type.getTypeByJavaClass(field.getType()) == null) {
                field.set(returnObj, new XStream().fromXML(result.getString(internalFieldName)));
                continue;
            }
            if (Type.getTypeByJavaClass(field.getType()).getType() == Type.Types.STRING) {
                field.set(returnObj, result.getString(internalFieldName));
                continue;
            }
            logger.trace("method is " + mapping.get(internalFieldName).getType().getReflectionMethodGet());
            rsMethod = ResultSet.class.getDeclaredMethod(mapping.get(internalFieldName).getType().getReflectionMethodGet(), String.class);
            field.set(returnObj, rsMethod.invoke((Object)result, internalFieldName));
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != null) {
            if (clazz.getSuperclass().equals(ObjectStateControl.class)) {
                Field superClassField = clazz.getSuperclass().getDeclaredField("objectversion");
                superClassField.setAccessible(true);
                superClassField.setInt(returnObj, result.getInt("objectversion"));
            } else {
                this.createObjectInternal(clazz.getSuperclass(), mapping, returnObj, classTableMap, result);
            }
        }
    }

    private class FieldMappingPair {
        private TreeMap<String, String> fieldMapping;
        private List<ColumnDefinition> columnsDefinition;

        public FieldMappingPair(TreeMap<String, String> fieldMapping, List<ColumnDefinition> columnsDefinition) {
            this.fieldMapping = fieldMapping;
            this.columnsDefinition = columnsDefinition;
        }

        public TreeMap<String, String> getFieldMapping() {
            return this.fieldMapping;
        }

        public List<ColumnDefinition> getColumnsDefinition() {
            return this.columnsDefinition;
        }
    }
}

