/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.pool;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.gcube.common.dbinterface.pool.DBSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPoolFactory
extends BasePoolableObjectFactory<DBSession> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectPoolFactory.class);
    private String dsn;
    private String usr;
    private String pwd;

    protected ObjectPoolFactory(String driver, String dsn, String usr, String pwd) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            logger.error("error getting db drivers", (Throwable)e);
        }
        this.dsn = dsn;
        this.usr = usr;
        this.pwd = pwd;
    }

    public DBSession makeObject() throws Exception {
        try {
            return new DBSession(DriverManager.getConnection(this.dsn, this.usr, this.pwd));
        }
        catch (SQLException e) {
            logger.error("error connecting with the Database", (Throwable)e);
            return null;
        }
    }

    public void passivateObject(DBSession dbSession) {
        try {
            dbSession.getConnection().setAutoCommit(false);
        }
        catch (SQLException e) {
            logger.warn("error passivating connection", (Throwable)e);
        }
    }

    public void destroyObject(DBSession obj) throws Exception {
        obj.closeConnection();
    }

    public boolean validateObject(DBSession obj) {
        try {
            return !obj.isConnectionClosed();
        }
        catch (Exception e) {
            return false;
        }
    }
}

