/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.tables;

import java.sql.ResultSet;
import java.util.LinkedHashMap;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;

public class SimpleTable
extends Table {
    private static final long serialVersionUID = 1874819829226263856L;
    private LinkedHashMap<String, Type> fieldsMapping = null;
    private int count = -1;
    private static transient GCUBELog logger = new GCUBELog(SimpleTable.class);

    public SimpleTable(String tableName) {
        super(tableName);
    }

    public SimpleTable(String tableName, String tableAlias) {
        super(tableName, tableAlias);
    }

    public void initializeFieldMapping(DBSession session) throws Exception {
        GetMetadata metadata = DBSession.getImplementation(GetMetadata.class);
        metadata.setTable(this.getTableName());
        this.fieldsMapping = metadata.getResults(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFieldMapping() throws Exception {
        DBSession session = DBSession.connect();
        try {
            this.initializeFieldMapping(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() throws Exception {
        if (this.count == -1) {
            this.initializeCount();
        }
        logger.debug((Object)("count for table " + this.getTable() + " is " + this.count));
        return this.count;
    }

    public void initializeCount(DBSession session) throws Exception {
        Select select = DBSession.getImplementation(Select.class);
        select.setTables(new Table(this.getTableName()));
        select.setAttributes(new AggregatedAttribute("*", AggregationFunctions.COUNT));
        logger.debug((Object)("select query for count is " + select.getExpression()));
        ResultSet rs = select.getResults(session, new boolean[0]);
        rs.next();
        this.count = rs.getInt(1);
        logger.debug((Object)("inzializing count for table " + this.getTable() + ", it is " + this.count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeCount() throws Exception {
        DBSession session = DBSession.connect();
        try {
            this.initializeCount(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public LinkedHashMap<String, Type> getFieldsMapping() throws Exception {
        if (this.fieldsMapping != null) {
            return this.fieldsMapping;
        }
        this.initializeFieldMapping();
        return this.fieldsMapping;
    }

    public void setFieldsMapping(LinkedHashMap<String, Type> fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
    }
}

