/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.iam;

import java.security.PublicKey;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.iam.D4ScienceIAMClientException;
import org.gcube.common.iam.IAMResponse;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.RefreshToken;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.io.jsonwebtoken.ExpiredJwtException;
import org.gcube.io.jsonwebtoken.security.SignatureException;

public class AbstractIAMResponse
implements IAMResponse {
    private D4ScienceIAMClient iamClient;
    private TokenResponse tokenResponse;

    public AbstractIAMResponse(D4ScienceIAMClient iamClient, TokenResponse tokenResponse) {
        this.setIamClient(iamClient);
        this.setTokenResponse(tokenResponse);
    }

    public void setIamClient(D4ScienceIAMClient iamClient) {
        this.iamClient = iamClient;
    }

    public D4ScienceIAMClient getIamClient() {
        return this.iamClient;
    }

    public void setTokenResponse(TokenResponse tokenResponse) {
        this.tokenResponse = tokenResponse;
    }

    protected TokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    @Override
    public AccessToken getAccessToken() throws D4ScienceIAMClientException {
        try {
            return ModelUtils.getAccessTokenFrom((TokenResponse)this.getTokenResponse());
        }
        catch (Exception e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    @Override
    public String getAccessTokenString() {
        return this.getTokenResponse().getAccessToken();
    }

    @Override
    public boolean isExpired() throws D4ScienceIAMClientException {
        try {
            return ModelUtils.getAccessTokenFrom((TokenResponse)this.getTokenResponse()).isExpired();
        }
        catch (Exception e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    public String getRefreshTokenString() {
        return this.getTokenResponse().getRefreshToken();
    }

    @Override
    public boolean canBeRefreshed() throws D4ScienceIAMClientException {
        try {
            RefreshToken refreshToken = ModelUtils.getRefreshTokenFrom((TokenResponse)this.getTokenResponse());
            return refreshToken != null && !refreshToken.isExpired();
        }
        catch (Exception e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    @Override
    public void refresh() throws D4ScienceIAMClientException {
        try {
            KeycloakClient keycloakClient = this.iamClient.getKeycloakClient();
            this.tokenResponse = keycloakClient.refreshToken(keycloakClient.getTokenEndpointURL(this.getIamClient().getRealmBaseURL()), this.getTokenResponse());
        }
        catch (KeycloakClientException e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    @Override
    public Set<String> getGlobalRoles() throws D4ScienceIAMClientException {
        AccessToken accessToken = this.getAccessToken();
        return accessToken.getRealmAccess() != null ? accessToken.getRealmAccess().getRoles() : new HashSet();
    }

    @Override
    public Set<String> getRoles() throws D4ScienceIAMClientException {
        AccessToken accessToken = this.getAccessToken();
        Set<String> roles = this.getGlobalRoles();
        accessToken.getResourceAccess().forEach((r, a) -> roles.addAll(a.getRoles()));
        return roles;
    }

    @Override
    public Set<String> getResourceRoles(String resource) throws D4ScienceIAMClientException {
        AccessToken accessToken = this.getAccessToken();
        return accessToken.getResourceAccess() != null ? (accessToken.getResourceAccess().get(resource) != null ? ((AccessToken.Access)accessToken.getResourceAccess().get(resource)).getRoles() : new HashSet()) : new HashSet();
    }

    @Override
    public Set<String> getContextRoles() throws D4ScienceIAMClientException {
        AccessToken accessToken = this.getAccessToken();
        return accessToken.getResourceAccess() != null ? (accessToken.getResourceAccess().get(accessToken.getAudience()[0]) != null ? ((AccessToken.Access)accessToken.getResourceAccess().get(accessToken.getAudience()[0])).getRoles() : new HashSet()) : new HashSet();
    }

    @Override
    public String getName() throws D4ScienceIAMClientException {
        return this.getAccessToken().getName();
    }

    @Override
    public String getContactPerson() throws D4ScienceIAMClientException {
        AccessToken accessToken = this.getAccessToken();
        return accessToken.getOtherClaims() != null ? accessToken.getOtherClaims().get("contact_person") : null;
    }

    @Override
    public String getContactOrganization() throws D4ScienceIAMClientException {
        AccessToken accessToken = this.getAccessToken();
        return accessToken.getOtherClaims() != null ? accessToken.getOtherClaims().get("contact_organisation") : null;
    }

    @Override
    public boolean isAccessTokenValid() throws D4ScienceIAMClientException {
        return this.isAccessTokenValid(true);
    }

    @Override
    public boolean isAccessTokenValid(boolean checkExpiration) throws D4ScienceIAMClientException {
        KeycloakClient keycloakClient = this.iamClient.getKeycloakClient();
        try {
            return ModelUtils.isValid((String)this.getAccessTokenString(), (PublicKey)keycloakClient.getRealmInfo(this.iamClient.getRealmBaseURL()).getPublicKey(), (boolean)checkExpiration);
        }
        catch (Exception e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    @Override
    public void verifyAccessToken() throws SignatureException, ExpiredJwtException, D4ScienceIAMClientException {
        try {
            this.getIamClient().verifyToken(this.getAccessTokenString());
        }
        catch (ExpiredJwtException | SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    @Override
    public boolean isRefreshTokenValid() throws D4ScienceIAMClientException {
        return this.isRefreshTokenValid(true);
    }

    @Override
    public boolean isRefreshTokenValid(boolean checkExpiration) throws D4ScienceIAMClientException {
        KeycloakClient keycloakClient = this.iamClient.getKeycloakClient();
        String refreshTokenString = this.getRefreshTokenString();
        try {
            return refreshTokenString != null && ModelUtils.isValid((String)refreshTokenString, (PublicKey)keycloakClient.getRealmInfo(this.iamClient.getRealmBaseURL()).getPublicKey(), (boolean)checkExpiration);
        }
        catch (Exception e) {
            throw new D4ScienceIAMClientException(e);
        }
    }

    @Override
    public void verifyRefreshToken() throws SignatureException, ExpiredJwtException, D4ScienceIAMClientException {
        String refreshTokenString = this.getRefreshTokenString();
        if (refreshTokenString == null) {
            try {
                this.getIamClient().verifyToken(refreshTokenString);
            }
            catch (ExpiredJwtException | SignatureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new D4ScienceIAMClientException(e);
            }
        }
    }
}

