package org.gcube.context.authorization;

import static org.gcube.common.authorization.client.Constants.authorizationService;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class TokensUtil {

	private static final Logger logger = LoggerFactory.getLogger(TokensUtil.class); 

	
	public static Map<String, String> getTokenForContexts(File voFile, String username, String serviceName) throws Exception{
		Map<String, String> scopeTokenMap = new HashMap<String, String>();
		ObjectMapper objectMapper = new ObjectMapper();
		ObjectNode objectNode = objectMapper.createObjectNode();
		
		try {
			
			LinkedHashMap<String, ScopeBean> map = ScopeManager.readScopes(voFile.getAbsolutePath());
			for(String scope : map.keySet()) {
				try {
					String context = map.get(scope).toString();
					System.out.println("Going to generate Token for Context " + context);
					logger.info("Going to generate Token for Context {}", context);
					UserInfo userInfo = new UserInfo(username, new ArrayList<>());
					String userToken = authorizationService().generateUserToken(userInfo, context);
					SecurityTokenProvider.instance.set(userToken);
					String generatedToken = authorizationService().generateExternalServiceToken(serviceName);
					scopeTokenMap.put(context, generatedToken);
					objectNode.put(context, generatedToken);
					
					logger.info("Token for Context {} is {}", context, generatedToken);
				}catch (Exception e) {
					logger.error("Error while elaborating {}", scope, e);
					throw e;
				} finally {
					SecurityTokenProvider.instance.reset();
				}
			}
		} catch (Exception ex) {
			throw ex;
		}
		
		File tokenFile = new File("tokens-"+serviceName+".json");
		objectMapper.writeValue(tokenFile, objectNode);
		
		return scopeTokenMap;
	}
	
	public static void main(String[] args) throws Exception {
		if(args.length!=3) {
			System.out.println("Please provide 'vo file path' as first argument 'username' as second and 'external application name' as third");
			return;
		}
		File voFile = new File(args[0]);
		if(!voFile.exists()) {
			System.out.println(args[0] + " does not exists");
			return;
		}
		getTokenForContexts(voFile, args[1], args[2]);
	}

}
