package org.gcube.common.context;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@SuppressWarnings("deprecation")
public class ContextUtility {

	public static String getCurrentContextFullName() {
		String context = ScopeProvider.instance.get();
		if(context==null) {
			String token = AccessTokenProvider.instance.get();
			String realUmaTokenEncoded = token.split("\\.")[1];
			String realUmaToken = new String(Base64.getDecoder().decode(realUmaTokenEncoded.getBytes()));
			ObjectMapper mapper = new ObjectMapper();
			try {
				JsonNode tokenJsonNode = mapper.readTree(realUmaToken);
				JsonNode jsonNode = tokenJsonNode.get("aud");
				if(jsonNode.isArray()) {
					ArrayNode arrayNode = (ArrayNode) jsonNode;
					for (JsonNode aud : arrayNode) {
						if (aud != null && aud.isTextual() && aud.asText().compareTo("") != 0) {
							String audience = aud.asText();
							String contextToBeValidated = URLDecoder.decode(audience, StandardCharsets.UTF_8.toString());
							ScopeBean scopeBean = new ScopeBean(contextToBeValidated);
							context = scopeBean.toString();
							return context;
						}
					}
				}
				if(jsonNode.isTextual()) {
					return jsonNode.asText();
				}
				throw new Exception("Unable to get Current Context");
			}catch (Exception e) {
				new RuntimeException(e);
			}
		}
		return context;
	}
	
}
