package org.gcube.common.security.exception;

/**
 * An exception class that indicates a security violation.
 * <p>
 * This is a runtime exception, meaning it does not need to be declared in a method's
 * {@code throws} clause. It can be thrown when an operation fails due to insufficient
 * permissions, unauthorized access, or other security-related issues.
 */
public class SecurityException extends RuntimeException {

	/**
	 * A unique serial version identifier for this class.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructs a new {@code SecurityException} with {@code null} as its detail message.
	 * The cause is not initialized, and may subsequently be initialized by a call to
	 * {@link Throwable#initCause(Throwable) initCause}.
	 */
	public SecurityException() {
		super();
	}

	/**
	 * Constructs a new {@code SecurityException} with the specified detail message,
	 * cause, suppression enabled or disabled, and writable stack trace enabled or disabled.
	 *
	 * @param message The detail message.
	 * @param cause The cause. (A {@code null} value is permitted, and indicates that
	 * the cause is nonexistent or unknown.)
	 * @param enableSuppression Whether or not suppression is enabled or disabled.
	 * @param writableStackTrace Whether or not the stack trace should be writable.
	 */
	public SecurityException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
		super(message, cause, enableSuppression, writableStackTrace);
	}

	/**
	 * Constructs a new {@code SecurityException} with the specified detail message and cause.
	 *
	 * @param message The detail message.
	 * @param cause The cause. (A {@code null} value is permitted, and indicates that
	 * the cause is nonexistent or unknown.)
	 */
	public SecurityException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * Constructs a new {@code SecurityException} with the specified detail message.
	 *
	 * @param message The detail message. The detail message is saved for
	 * later retrieval by the {@link Throwable#getMessage() getMessage()} method.
	 */
	public SecurityException(String message) {
		super(message);
	}

	/**
	 * Constructs a new {@code SecurityException} with the specified cause and a detail
	 * message of {@code (cause==null ? null : cause.toString())} (which typically
	 * contains the class and detail message of {@code cause}). This constructor is
	 * useful for exceptions that are little more than wrappers for other throwables.
	 *
	 * @param cause The cause. (A {@code null} value is permitted, and indicates that
	 * the cause is nonexistent or unknown.)
	 */
	public SecurityException(Throwable cause) {
		super(cause);
	}
}