/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.jaxrs;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.xml.ws.EndpointReference;
import org.gcube.common.calls.jaxrs.GcubeService;
import org.gcube.common.calls.jaxrs.JaxRSEndpointReference;
import org.gcube.common.calls.jaxrs.JaxRSRequestFilter;
import org.gcube.common.calls.jaxrs.TargetFactoryDSL;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFactory
implements TargetFactoryDSL.AtClause {
    private static Logger log = LoggerFactory.getLogger(TargetFactory.class);
    private GcubeService target;

    public static TargetFactory stubFor(GcubeService target) {
        return new TargetFactory(target);
    }

    private TargetFactory(GcubeService target) {
        this.target = target;
    }

    @Override
    public GXWebTargetAdapterRequest getAsGxRest(String address) {
        try {
            GXWebTargetAdapterRequest webTarget = null;
            if (address.startsWith("https")) {
                log.info("using secure call");
                webTarget = GXWebTargetAdapterRequest.newHTTPSRequest((String)address).path(this.target.path());
            } else {
                webTarget = GXWebTargetAdapterRequest.newRequest((String)address).path(this.target.path());
            }
            webTarget.configProperty("jersey.config.client.request.entity.processing", "CHUNKED");
            webTarget.register((Object)new JaxRSRequestFilter(this.target));
            return webTarget;
        }
        catch (Exception e) {
            log.error("error building service", (Throwable)e);
            throw new RuntimeException("error building service", e);
        }
    }

    @Override
    public WebTarget at(String address) {
        try {
            Client client = (Client)((Client)((Client)((Client)ClientBuilder.newClient().property("jersey.config.client.followRedirects", (Object)Boolean.FALSE)).property("jersey.config.client.chunkedEncodingSize", (Object)0x100000)).property("jersey.config.client.contentLength.buffer", (Object)-1)).property("jersey.config.client.request.entity.processing", (Object)"CHUNKED");
            WebTarget webTarget = client.target(address).path(this.target.path());
            webTarget.register((Object)new JaxRSRequestFilter(this.target));
            return webTarget;
        }
        catch (Exception e) {
            log.error("error building service", (Throwable)e);
            throw new RuntimeException("error building service", e);
        }
    }

    public WebTarget at(EndpointReference endpoint) {
        return this.at(new JaxRSEndpointReference((EndpointReference)endpoint).address);
    }
}

