/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.calls.jaxrs;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.xml.ws.EndpointReference;
import org.gcube.common.calls.jaxrs.GcubeService;
import org.gcube.common.calls.jaxrs.JaxRSEndpointReference;
import org.gcube.common.calls.jaxrs.JaxRSRequestFilter;
import org.gcube.common.calls.jaxrs.TargetFactoryDSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFactory
implements TargetFactoryDSL.AtClause {
    private static Logger log = LoggerFactory.getLogger(TargetFactory.class);
    private GcubeService target;

    public static TargetFactory stubFor(GcubeService target) {
        return new TargetFactory(target);
    }

    private TargetFactory(GcubeService target) {
        this.target = target;
    }

    @Override
    public WebTarget at(String address) {
        try {
            Client client = (Client)ClientBuilder.newClient().property("jersey.config.client.followRedirects", (Object)Boolean.FALSE);
            System.out.println("address is " + address);
            WebTarget webTarget = client.target(address).path(this.target.path());
            webTarget.register((Object)new JaxRSRequestFilter(this.target));
            return webTarget;
        }
        catch (Exception e) {
            log.error("error building service", (Throwable)e);
            throw new RuntimeException("error building service", e);
        }
    }

    public WebTarget at(EndpointReference endpoint) {
        return this.at(new JaxRSEndpointReference((EndpointReference)endpoint).address);
    }
}

