/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.gcube.common.authorization.utils.manager.SecretHolder;
import org.gcube.common.authorization.utils.provider.GCubeSecretProvider;
import org.gcube.common.authorization.utils.provider.SecretProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.user.User;

public class SecretManager {
    public static final InheritableThreadLocal<SecretManager> instance = new InheritableThreadLocal<SecretManager>(){

        @Override
        protected SecretManager initialValue() {
            return new SecretManager();
        }
    };
    private List<SecretProvider> secretProviders;
    private SecretHolder initialSecretHolder;
    private SecretHolder currentSecretHolder;

    private SecretManager() {
        this.currentSecretHolder = this.initialSecretHolder = new SecretHolder();
        this.initSecretProviders();
    }

    protected void initSecretProviders() {
        Class[] classes;
        this.secretProviders = new ArrayList<SecretProvider>();
        for (Class clz : classes = new Class[]{JWTSecret.class, GCubeSecretProvider.class}) {
            try {
                SecretProvider authorizationSecretProvider = (SecretProvider)clz.newInstance();
                this.addSecretProvider(authorizationSecretProvider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<SecretProvider> getSecretProviders() {
        return this.secretProviders;
    }

    public void addSecretProvider(SecretProvider secretProvider) {
        this.secretProviders.add(secretProvider);
        Secret secret = secretProvider.getSecret();
        this.initialSecretHolder.addSecret(secret);
    }

    public synchronized void startSession(Secret secret) throws Exception {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            throw new Exception("You are already in a session. You must terminate the session first.");
        }
        this.currentSecretHolder = new SecretHolder(secret);
        this.currentSecretHolder.set();
    }

    public synchronized void startSession(SortedSet<Secret> secrets) throws Exception {
        this.currentSecretHolder = new SecretHolder(secrets);
        this.currentSecretHolder.set();
    }

    public synchronized void endSession() throws Exception {
        if (this.currentSecretHolder != this.initialSecretHolder) {
            this.initialSecretHolder.set();
            this.currentSecretHolder = this.initialSecretHolder;
        }
    }

    public void reset() {
        this.initialSecretHolder.reset();
        if (this.initialSecretHolder != this.currentSecretHolder) {
            this.currentSecretHolder.reset();
        }
        instance.remove();
    }

    public String getContext() {
        return this.currentSecretHolder.getContext();
    }

    public User getUser() {
        return this.currentSecretHolder.getUser();
    }
}

