/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.filters;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorizationservice.configuration.AllowedEntity;
import org.gcube.common.authorizationservice.configuration.AuthorizationConfiguration;
import org.gcube.common.authorizationservice.configuration.AuthorizationRule;
import org.gcube.common.authorizationservice.configuration.ConfigurationHolder;
import org.gcube.common.authorizationservice.filters.AuthorizedCallFilter;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@WebFilter(urlPatterns={"/*"}, filterName="authorizationFilter")
public class AuthorizedCallFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthorizedCallFilter.class);
    private static final String TOKEN_HEADER = "gcube-token";
    public static final String AUTH_ATTRIBUTE = "authorizationInfo";
    @Inject
    TokenPersistence persistence;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String token = request.getParameter("gcube-token") == null ? ((HttpServletRequest)request).getHeader("gcube-token") : request.getParameter("gcube-token");
        AuthorizationEntry info = null;
        if (token != null) {
            info = this.persistence.getAuthorizationEntry(token);
            log.info("call from {} ", (Object)info);
        } else {
            log.info("call without token");
        }
        request.setAttribute("authorizationInfo", (Object)info);
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        log.info("called path {}", (Object)pathInfo);
        if (pathInfo == null || pathInfo.isEmpty()) {
            log.info("call rejected from filters: invalid path info");
            return;
        }
        if (this.requiresToken(pathInfo) && token == null) {
            ((HttpServletResponse)response).sendError(401);
            log.info("call rejected from filters, call requires caller token");
            return;
        }
        String callerIp = ((HttpServletRequest)request).getHeader("x-forwarded-for");
        if (callerIp == null) {
            callerIp = request.getRemoteHost();
        }
        log.info("caller ip {}", (Object)callerIp);
        if (!this.checkAllowed(pathInfo, callerIp, info)) {
            ((HttpServletResponse)response).sendError(401);
            log.info("call rejected from filters");
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean requiresToken(String pathInfo) {
        AuthorizationConfiguration conf = ConfigurationHolder.getConfiguration();
        List rules = conf.getAuthorizationRules();
        for (AuthorizationRule rule : rules) {
            if (!pathInfo.startsWith(rule.getServletPath()) && !pathInfo.equals(rule.getServletPath())) continue;
            return rule.isTokenRequired();
        }
        return false;
    }

    private boolean checkAllowed(String pathInfo, String callerIp, AuthorizationEntry info) {
        AuthorizationConfiguration conf = ConfigurationHolder.getConfiguration();
        List rules = conf.getAuthorizationRules();
        for (AuthorizationRule rule : rules) {
            if (!pathInfo.startsWith(rule.getServletPath()) && !pathInfo.equals(rule.getServletPath())) continue;
            if (!rule.getAcceptedTokenType().isEmpty() && !rule.getAcceptedTokenType().contains(info.getClientInfo().getType())) {
                log.info("rejecting the call: callerType {} is not in the allowed types defined {} ", (Object)info.getClientInfo().getType(), (Object)rule.getAcceptedTokenType());
                return false;
            }
            if (rule.getEntities().isEmpty()) continue;
            for (AllowedEntity entity : rule.getEntities()) {
                switch (1.$SwitchMap$org$gcube$common$authorizationservice$configuration$AllowedEntity$EntityType[entity.getType().ordinal()]) {
                    case 1: {
                        log.trace("checking ip rule : {} -> {}", (Object)entity.getValue(), (Object)callerIp);
                        if (!AuthorizedCallFilter.checkIpInRange((String)callerIp, (String)entity.getValue())) break;
                        return true;
                    }
                    case 2: {
                        log.trace("checking user rule : {} -> {}", (Object)entity.getValue(), (Object)info.getClientInfo().getId());
                        if (!entity.getValue().equals(info.getClientInfo().getId())) break;
                        return true;
                    }
                    case 3: {
                        log.trace("checking role rule : {} -> {}", (Object)entity.getValue(), (Object)info.getClientInfo().getRoles());
                        if (!info.getClientInfo().getRoles().contains(entity.getValue())) break;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private static boolean checkIpInRange(String ip, String mask) {
        String[] maskArray = mask.split("\\.");
        String[] ipArray = ip.split("\\.");
        int[] maskByte = new int[4];
        int[] ipByte = new int[4];
        for (int i = 0; i < 4; ++i) {
            maskByte[i] = Integer.valueOf(Integer.parseInt(maskArray[i])).byteValue();
            ipByte[i] = Integer.valueOf(Integer.parseInt(ipArray[i])).byteValue();
        }
        return !(maskByte[0] != 0 && maskByte[0] != ipByte[0] || maskByte[1] != 0 && maskByte[1] != ipByte[1] || maskByte[2] != 0 && maskByte[2] != ipByte[2] || maskByte[3] != 0 && maskByte[3] != ipByte[3]);
    }

    public void destroy() {
    }
}

