/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice;

import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.BannedService;
import org.gcube.common.authorization.library.BannedServices;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="deny/{user}")
public class Denier {
    private static final Logger log = LoggerFactory.getLogger(Denier.class);
    @Inject
    TokenPersistence tokenPersistence;

    @POST
    @Path(value="/{serviceClass}/{serviceName}")
    @Produces(value={"application/xml"})
    public BannedService banUserToService(@NotNull @PathParam(value="user") String userName, @PathParam(value="serviceClass") String serviceClass, @PathParam(value="serviceName") String serviceName) {
        try {
            log.info("banning service {}[{}] for user {} in scope {}", new Object[]{serviceName, serviceClass, userName, ScopeProvider.instance.get()});
            return this.tokenPersistence.denyServiceForUser(userName, serviceClass, serviceName, ScopeProvider.instance.get());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Banning Service: " + e.getMessage())).type("text/plain").build());
        }
    }

    @DELETE
    @Path(value="/{serviceClass}/{serviceName}")
    public void allowUserToService(@NotNull @PathParam(value="user") String userName, @PathParam(value="serviceClass") String serviceClass, @PathParam(value="serviceName") String serviceName) {
        try {
            log.info("allowing service {}[{}] for user {} in scope {}", new Object[]{serviceName, serviceClass, userName, ScopeProvider.instance.get()});
            this.tokenPersistence.allowServiceForUser(userName, serviceClass, serviceName, ScopeProvider.instance.get());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Allowing Service: " + e.getMessage())).type("text/plain").build());
        }
    }

    @GET
    @Produces(value={"application/xml"})
    public BannedServices getBannedServicesForUser(@NotNull @PathParam(value="user") String userName) {
        try {
            log.debug("retrieving banned services for user {} in scope {}", (Object)userName, (Object)ScopeProvider.instance.get());
            return new BannedServices(this.tokenPersistence.getBannedServices(userName, ScopeProvider.instance.get()));
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error Allowing Service: " + e.getMessage())).type("text/plain").build());
        }
    }
}

