/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.persistence;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.BannedService;
import org.gcube.common.authorizationservice.util.BannedEntry;
import org.gcube.common.authorizationservice.util.TokenMappingEntity;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.gcube.common.couchdb.connector.Entity;
import org.gcube.common.couchdb.connector.HttpCouchClient;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CouchDBTokenPersistence
implements TokenPersistence {
    private static final Logger log = LoggerFactory.getLogger(CouchDBTokenPersistence.class);
    private Map<String, HttpCouchClient> mapsScopeClient = new HashMap();
    private final String DESIGN_NAME = "_gcube";
    private final String TOKEN_BY_USER_AND_SCOPE = "_user_and_scope";
    private final String BANNED_SERVICES = "_bannedservice";
    private final String BANNED_SERVICE_PER_USER_AND_SCOPE = "_banned_service_per_user_scope";

    public void saveAuthorizationEntry(String token, AuthorizationEntry authorizationEntry) {
        try {
            TokenMappingEntity tme = new TokenMappingEntity(token, authorizationEntry);
            this.getClient().put((Entity)tme);
        }
        catch (Exception e) {
            log.error("error saving token " + token);
        }
    }

    public AuthorizationEntry getAuthorizationEntry(String token) {
        try {
            TokenMappingEntity tme = (TokenMappingEntity)this.getClient().getDoc(token, TokenMappingEntity.class);
            return new AuthorizationEntry(tme.getUserName(), tme.getRoles(), tme.getScope());
        }
        catch (Exception e) {
            log.error("error retrieving token " + token, (Throwable)e);
            throw new RuntimeException("error retrieving token " + token);
        }
    }

    public String getExistingToken(AuthorizationEntry authorizationEntry) {
        try {
            List mappingEntries = this.getClient().getFilteredDocs(TokenMappingEntity.class, "_gcube", "_user_and_scope", new String[]{authorizationEntry.getUserName(), authorizationEntry.getScope()});
            if (mappingEntries.isEmpty()) {
                return null;
            }
            return ((TokenMappingEntity)mappingEntries.get(0)).getToken();
        }
        catch (Exception e) {
            log.error("error retrieving authorizationEntry " + authorizationEntry, (Throwable)e);
            throw new RuntimeException("error retrieving authorizationEntry " + authorizationEntry);
        }
    }

    public synchronized BannedService denyServiceForUser(String userName, String serviceClass, String serviceName, String scope) {
        try {
            BannedEntry be = new BannedEntry(userName, scope, serviceName, serviceClass);
            List mappingEntries = this.getClient().getFilteredDocs(BannedEntry.class, "_gcube", "_bannedservice", new String[]{userName, serviceClass, serviceName, scope});
            if (mappingEntries.isEmpty()) {
                this.getClient().put((Entity)be);
            } else {
                be = (BannedEntry)mappingEntries.get(0);
            }
            return new BannedService(be.getServiceClass(), be.getServiceName(), be.getBanTime());
        }
        catch (Exception e) {
            String message = String.format("error banning service %s:%s for user %s in scope %s", serviceClass, serviceName, userName, scope);
            log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public void allowServiceForUser(String userName, String serviceClass, String serviceName, String scope) {
        try {
            List mappingEntries = this.getClient().getFilteredDocs(BannedEntry.class, "_gcube", "_bannedservice", new String[]{userName, serviceClass, serviceName, scope});
            if (mappingEntries.isEmpty()) {
                return;
            }
            BannedEntry service = (BannedEntry)mappingEntries.get(0);
            this.getClient().delete((Entity)service);
        }
        catch (Exception e) {
            String message = String.format("error removing banned service %s:%s for user %s in scope %s", serviceClass, serviceName, userName, scope);
            log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public List<BannedService> getBannedServices(String userName, String scope) {
        try {
            List mappingEntries = this.getClient().getFilteredDocs(BannedEntry.class, "_gcube", "_banned_service_per_user_scope", new String[]{userName, scope});
            if (mappingEntries.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<BannedService> services = new ArrayList<BannedService>(mappingEntries.size());
            for (BannedEntry entry : mappingEntries) {
                services.add(new BannedService(entry.getServiceClass(), entry.getServiceName(), entry.getBanTime()));
            }
            return services;
        }
        catch (Exception e) {
            String message = String.format("error getting banned service for user %s in scope %s", userName, scope);
            log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public HttpCouchClient getClient() {
        if (!this.mapsScopeClient.containsKey(ScopeProvider.instance.get())) {
            log.debug("retrieving enpoint of couch-db for scope {} ", (Object)ScopeProvider.instance.get());
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Name/text() eq 'AuthorizationDB'").setResult("$resource/Profile//AccessPoint[./Interface/Endpoint/@EntryName eq 'authorization']");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
            List results = client.submit((Query)query);
            if (results.size() > 0) {
                ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)results.get(0);
                try {
                    this.mapsScopeClient.put(ScopeProvider.instance.get(), new HttpCouchClient(ap.address(), ap.name(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0])));
                }
                catch (Exception e) {
                    new IllegalArgumentException("error decrypting password", e);
                }
            } else {
                throw new IllegalStateException("no endpoint retreived for AuthorizationDB");
            }
        }
        return (HttpCouchClient)this.mapsScopeClient.get(ScopeProvider.instance.get());
    }
}

