package org.gcube.common.authorizationservice.library;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class AuthorizationEntry {

	private String userName;
	private String role;
	private String scope;
	
	protected AuthorizationEntry(){}
	
	public AuthorizationEntry(String userName, String role, String scope) {
		super();
		this.userName = userName;
		this.role = role;
		this.scope = scope;
	}

	public String getUserName() {
		return userName;
	}

	public String getRole() {
		return role;
	}

	public String getScope() {
		return scope;
	}

	@Override
	public String toString() {
		return "AuthorizationEntry [userName=" + userName + ", role=" + role
				+ ", scope=" + scope + "]";
	}
	
	
	
}
