/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar;

import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.gcube.keycloak.avatar.storage.file.FileAvatarStorageProvider;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public abstract class AbstractAvatarResource {
    protected static final Logger logger = Logger.getLogger(AbstractAvatarResource.class);
    protected static final String AVATAR_IMAGE_PARAMETER = "image";
    public static final Class<?> DEFAULT_IMPLEMENTATION = FileAvatarStorageProvider.class;
    protected KeycloakSession session;
    protected AuthenticationManager.AuthResult auth;

    public AbstractAvatarResource(KeycloakSession session) {
        this.session = session;
        this.auth = this.authenticate(session);
    }

    private AuthenticationManager.AuthResult authenticate(KeycloakSession session) {
        logger.debug((Object)"Authenticating with bearer token");
        AuthenticationManager.AuthResult auth = new AppAuthManager().authenticateBearerToken(session, session.getContext().getRealm());
        if (auth == null) {
            logger.debug((Object)"Authenticating with identity cookie");
            auth = new AppAuthManager().authenticateIdentityCookie(session, session.getContext().getRealm());
        }
        return auth;
    }

    public AvatarStorageProvider getAvatarStorageProvider() {
        AvatarStorageProvider asp = this.lookupAvatarStorageProvider(this.session);
        if (asp == null) {
            logger.warnf("Provider not found via SPI configuration, defaulting to: %s", (Object)DEFAULT_IMPLEMENTATION.getName());
            try {
                asp = (AvatarStorageProvider)DEFAULT_IMPLEMENTATION.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error((Object)"Cannot instatiate storage implementation class", (Throwable)e);
            }
        }
        return asp;
    }

    protected AvatarStorageProvider lookupAvatarStorageProvider(KeycloakSession keycloakSession) {
        return (AvatarStorageProvider)keycloakSession.getProvider(AvatarStorageProvider.class);
    }

    protected void saveUserImage(RealmModel realm, UserModel user, InputStream imageInputStream) {
        this.getAvatarStorageProvider().saveAvatarImage(realm, user, imageInputStream);
    }

    protected StreamingOutput fetchUserImage(RealmModel realm, UserModel user) {
        AvatarStorageProvider asp = this.getAvatarStorageProvider();
        InputStream is = asp.loadAvatarImage(realm, user);
        return is != null ? output -> IOUtils.copy((InputStream)is, (OutputStream)output) : null;
    }

    protected Response fetchAndCreateResponse(RealmModel realm, UserModel user) {
        StreamingOutput so = this.fetchUserImage(realm, user);
        if (so == null) {
            throw new NotFoundException("Avatar image not found");
        }
        return Response.ok((Object)so).build();
    }
}

