/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.taskexecutionlogger;

import gr.uoa.di.madgik.taskexecutionlogger.exceptions.PropertiesFileRetrievalException;
import gr.uoa.di.madgik.taskexecutionlogger.model.WorkflowLogEntry;
import gr.uoa.di.madgik.taskexecutionlogger.utils.Constants;
import gr.uoa.di.madgik.taskexecutionlogger.utils.FileUtils;
import gr.uoa.di.madgik.taskexecutionlogger.utils.JSONConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class TaskExecutionLogger {
    private static final Logger log = Logger.getLogger(TaskExecutionLogger.class);
    private static TaskExecutionLogger logger = null;
    private BufferedWriter out = null;
    private static String path = null;
    private static String logFileName = null;
    private MessageHandlingThread worker = new MessageHandlingThread();
    private LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();

    private TaskExecutionLogger() {
        String fName = null;
        try {
            path = FileUtils.getPropertyValue("config.properties", "path");
            fName = FileUtils.getPropertyValue("config.properties", "file_name");
        }
        catch (PropertiesFileRetrievalException e) {
            log.error((Object)"Failed to retrieve the Path. Using system's temp directory");
            path = System.getProperty("java.io.tmpdir") + Constants.FILE_SEPARATOR + "executionLogs";
            fName = "workflows.log";
        }
        log.debug((Object)("Path is -> " + path));
        new File(path).mkdirs();
        try {
            logFileName = path + Constants.FILE_SEPARATOR + fName;
            File file = new File(logFileName);
            file.createNewFile();
            FileWriter fstream = new FileWriter(file, true);
            this.out = new BufferedWriter(fstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.worker.start();
    }

    public static TaskExecutionLogger getLogger() {
        if (logger == null) {
            logger = new TaskExecutionLogger();
        }
        return logger;
    }

    public void logTask(String task) {
        log.debug((Object)"Offering message to queue....");
        log.debug((Object)task);
        this.messageQueue.offer(task + Constants.LINE_SEPARATOR);
    }

    public List<String> getLogEntriesAsString() {
        try {
            File logFile = new File(logFileName);
            BufferedReader in = new BufferedReader(new FileReader(logFile));
            ArrayList<String> entries = new ArrayList<String>();
            String entry = in.readLine();
            while (entry != null) {
                entries.add(entry);
                entry = in.readLine();
            }
            return entries;
        }
        catch (Exception e) {
            log.debug((Object)"Failed to read the logs. An exception was thrown", (Throwable)e);
            return null;
        }
    }

    public List<WorkflowLogEntry> getLogEntriesAsObject() throws Exception {
        List<String> entries = this.getLogEntriesAsString();
        if (entries != null) {
            ArrayList<WorkflowLogEntry> workflowEntries = new ArrayList<WorkflowLogEntry>();
            for (String entry : entries) {
                workflowEntries.add((WorkflowLogEntry)JSONConverter.convertFromJSON(entry, WorkflowLogEntry.class));
            }
            return workflowEntries;
        }
        return null;
    }

    private class MessageHandlingThread
    extends Thread {
        public MessageHandlingThread() {
            log.debug((Object)"Creating a message handling object in order to handle the message queue");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String messageLine = (String)TaskExecutionLogger.this.messageQueue.take();
                        TaskExecutionLogger.this.out.write(messageLine);
                        TaskExecutionLogger.this.out.flush();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"An exception was thrown while trying to get the buffer writer.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

