/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.vremanagement.vremanagement.impl;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.vremanagement.vremanagement.SoftwareRepositoryI;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.types.VOID;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.vremanagement.softwarerepository.stubs.GetMessage;
import org.gcube.vremanagement.softwarerepository.stubs.ListScopedPackagesMessage;
import org.gcube.vremanagement.softwarerepository.stubs.ListScopedPackagesMessageScope;
import org.gcube.vremanagement.softwarerepository.stubs.SoftwareRepositoryPortType;
import org.gcube.vremanagement.softwarerepository.stubs.Store;
import org.gcube.vremanagement.softwarerepository.stubs.StoreItem;
import org.gcube.vremanagement.softwarerepository.stubs.service.SoftwareRepositoryServiceAddressingLocator;

public class SoftwareRepository
implements SoftwareRepositoryI {
    protected ASLSession session;
    protected static AtomicInteger srId = new AtomicInteger(0);

    public SoftwareRepository(ASLSession session) {
        this.session = session;
    }

    protected int getSRUrlsSize() {
        try {
            return RIsManager.getInstance().getISCache(this.session.getScope()).getEPRsFor("VREManagement", "SoftwareRepository", SrvType.SIMPLE.name()).length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected SoftwareRepositoryPortType getSRPortType() {
        EndpointReference[] urls = null;
        try {
            urls = RIsManager.getInstance().getISCache(this.session.getScope()).getEPRsFor("VREManagement", "SoftwareRepository", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        SoftwareRepositoryPortType srPort = null;
        try {
            serviceEPR.setAddress((AttributedURI)new Address(urls[srId.getAndIncrement() % urls.length].getAddress().toString()));
            SoftwareRepositoryServiceAddressingLocator srLocator = new SoftwareRepositoryServiceAddressingLocator();
            srPort = srLocator.getSoftwareRepositoryPortTypePort(serviceEPR);
            try {
                srPort = (SoftwareRepositoryPortType)ServiceContextManager.applySecurity((Remote)srPort, (ASLSession)this.session);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return srPort;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String store(String serviceClass, String serviceName, String serviceVersion, String URL2, String description) {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            Store storeMsg = new Store();
            StoreItem[] storeMessage = new StoreItem[]{new StoreItem()};
            storeMessage[0].setDescription(description);
            storeMessage[0].setScopes(scopes);
            storeMessage[0].setServiceClass(serviceClass);
            storeMessage[0].setServiceName(serviceName);
            storeMessage[0].setServiceVersion(serviceVersion);
            storeMessage[0].setURL(URL2);
            storeMsg.setStoreMessage(storeMessage);
            try {
                return srPort.store(storeMsg);
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String listPending() {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            try {
                return srPort.listPending(new VOID());
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String approve(String id) {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            try {
                return srPort.approve(id);
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String[] listScopedPackages(String scope, String serviceID) {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            ListScopedPackagesMessage scopePacks = new ListScopedPackagesMessage();
            scopePacks.setScope(ListScopedPackagesMessageScope.fromString((String)scope));
            scopePacks.setServiceID(serviceID);
            try {
                srPort.listScopedPackages(scopePacks);
                continue;
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String[] isDeployable(String serviceID) {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            try {
                srPort.isDeployable(serviceID);
                continue;
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String get(String packageName, String serviceClass, String serviceName, String serviceVersion, String version) {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            try {
                GetMessage getMsg = new GetMessage();
                getMsg.setPackageName(packageName);
                getMsg.setServiceClass(serviceClass);
                getMsg.setServiceName(serviceName);
                getMsg.setServiceVersion(serviceVersion);
                getMsg.setVersion(version);
                srPort.get(getMsg);
                continue;
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String delete(String vo) {
        int n = this.getSRUrlsSize();
        for (int i = 0; i < n; ++i) {
            SoftwareRepositoryPortType srPort = this.getSRPortType();
            String[] scopes = new String[]{this.session.getOriginalScopeName()};
            try {
                return srPort.delete(vo);
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                continue;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

