/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.userprofiles.commons;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.personalization.profileadministration.stubs.ProfileAdministrationPortType;
import org.gcube.personalization.profileadministration.stubs.service.ProfileAdministrationServiceAddressingLocator;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessFactoryPortType;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessFactoryServiceAddressingLocator;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessServiceAddressingLocator;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.GSSCredential;

public class ProfileService {
    protected static AtomicInteger profileId = new AtomicInteger(0);
    protected String username;
    protected GCUBEScope scope;

    public ProfileService(String username, GCUBEScope scope) {
        this.username = username;
        this.scope = scope;
    }

    public UserProfileAccessFactoryPortType getUserProfileAccessFactory() {
        EndpointReference[] profileURIs;
        try {
            profileURIs = RIsManager.getInstance().getISCache(this.scope).getEPRsFor("Personalisation", "UserProfileAccess", SrvType.FACTORY.name());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        System.out.println("getUserProfileAccessFactory: " + profileURIs.length);
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        UserProfileAccessFactoryPortType upa = null;
        try {
            serviceEPR.setAddress((AttributedURI)new Address(profileURIs[profileId.getAndIncrement() % profileURIs.length].getAddress().toString()));
            UserProfileAccessFactoryServiceAddressingLocator upalocator = new UserProfileAccessFactoryServiceAddressingLocator();
            upa = upalocator.getUserProfileAccessFactoryPortTypePort(serviceEPR);
            return upa;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public UserProfileAccessPortType getUserProfileAccess(ExtendedGSSCredential cred) {
        UserProfileAccessFactoryPortType upa = this.getUserProfileAccessFactory();
        try {
            upa = (UserProfileAccessFactoryPortType)ServiceContextManager.applySecurity((Remote)upa, (GCUBEScope)this.scope, (GSSCredential)cred);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EndpointReferenceType epr = null;
        try {
            System.out.println("\n\n\n\n" + this.username + " scope= " + this.scope + "\n\n\n\n");
            epr = upa.createResource(this.username);
        }
        catch (GCUBEFault e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (epr != null) {
            try {
                return this.getUserProfileAccessServicePortType(epr, this.scope, (GSSCredential)cred);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public UserProfileAccessPortType getUserProfileAccess(UserProfileAccessFactoryPortType upa, ExtendedGSSCredential cred) {
        try {
            upa = (UserProfileAccessFactoryPortType)ServiceContextManager.applySecurity((Remote)upa, (GCUBEScope)this.scope, (GSSCredential)cred);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EndpointReferenceType epr = null;
        try {
            epr = upa.createResource(this.username);
        }
        catch (GCUBEFault e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (epr != null) {
            try {
                return this.getUserProfileAccessServicePortType(epr, this.scope, (GSSCredential)cred);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private UserProfileAccessPortType getUserProfileAccessServicePortType(EndpointReferenceType epr, GCUBEScope scope, GSSCredential cred) throws RemoteException {
        UserProfileAccessServiceAddressingLocator instanceLocator = new UserProfileAccessServiceAddressingLocator();
        UserProfileAccessPortType port = null;
        try {
            port = instanceLocator.getUserProfileAccessPortTypePort(epr);
            try {
                port = (UserProfileAccessPortType)ServiceContextManager.applySecurity((Remote)port, (GCUBEScope)scope, (GSSCredential)cred);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            throw new RemoteException("A service exception was thrown. Failed to get the port type of the service user profile access");
        }
        return port;
    }

    public ProfileAdministrationPortType getProfileAdministration(GSSCredential cred) {
        EndpointReference[] profileURIs;
        try {
            profileURIs = RIsManager.getInstance().getISCache(this.scope).getEPRsFor("Personalisation", "ProfileAdministration", SrvType.SIMPLE.name());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        ProfileAdministrationPortType pa = null;
        System.out.println("profile administration services: " + profileURIs.length);
        try {
            serviceEPR.setAddress((AttributedURI)new Address(profileURIs[profileId.getAndIncrement() % profileURIs.length].getAddress().toString()));
            ProfileAdministrationServiceAddressingLocator palocator = new ProfileAdministrationServiceAddressingLocator();
            pa = palocator.getProfileAdministrationPortTypePort(serviceEPR);
            pa = (ProfileAdministrationPortType)ServiceContextManager.applySecurity((Remote)pa, (GCUBEScope)this.scope, (GSSCredential)cred);
            return pa;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

